/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import java.util.List;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.DefaultObjectTreeModel;
import officemate.adminkit.tree.ObjectTree;
import officemate.adminkit.tree.ObjectTreeNode;

public class DefaultObjectTree
extends ObjectTree {
    private List rootObjects;
    private ObjectTemplate template;

    public DefaultObjectTree(List rootObjs, ObjectTemplate objTemplate) {
        this(rootObjs, objTemplate, (ObjectFilter)null);
    }

    public DefaultObjectTree(List rootObjs, ObjectTemplate objTemplate, ObjectFilter objFilter) {
        this(rootObjs, objTemplate, new DefaultObjectTreeModel(rootObjs, objTemplate, objFilter));
    }

    public DefaultObjectTree(List rootObjs, ObjectTemplate objTemplate, DefaultObjectTreeModel model) {
        super(model);
        this.setRootVisible(true);
        this.setExpandsSelectedPaths(true);
        this.setShowsRootHandles(true);
        this.rootObjects = rootObjs;
        this.template = objTemplate;
    }

    public DefaultObjectTreeModel getObjectTreeModel() {
        return (DefaultObjectTreeModel)this.getModel();
    }

    public void refresh() {
        DefaultObjectTreeModel model = (DefaultObjectTreeModel)this.getModel();
        model.updateViews();
    }

    public void updateTreeNode(ObjectTreeNode toUpdate) {
        this.getObjectTreeModel().updateObjectTreeNode(toUpdate);
        this.getObjectTreeModel().reload(toUpdate);
    }

    public ObjectTemplate getTemplate() {
        return this.template;
    }

    public List getRootObjects() {
        return this.rootObjects;
    }

    public void setRootObjects(List rootObjs) {
        DefaultObjectTreeModel model = this.getObjectTreeModel();
        model.setRootObjects(rootObjs);
    }

    public void setObjectFilter(ObjectFilter filter) {
        DefaultObjectTreeModel model = this.getObjectTreeModel();
        model.setObjectFilter(filter);
    }

    public ObjectFilter getObjectFilter() {
        DefaultObjectTreeModel model = this.getObjectTreeModel();
        return model.getObjectFilter();
    }
}

