/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.ObjectTreeNode;

public class DefaultObjectTreeModel
extends DefaultTreeModel {
    private DefaultMutableTreeNode rootNode;
    private List rootObjects;
    private ObjectTemplate template;
    private ObjectFilter filter = null;

    public DefaultObjectTreeModel(List rootObjs, ObjectTemplate objTemp) {
        this(rootObjs, objTemp, null, null);
    }

    public DefaultObjectTreeModel(List rootObjs, ObjectTemplate objTemp, ObjectFilter objFilter) {
        this(rootObjs, objTemp, objFilter, null);
    }

    public DefaultObjectTreeModel(List rootObjs, ObjectTemplate objTemp, ObjectFilter objFilter, String treeRootName) {
        super(new DefaultMutableTreeNode(""), false);
        String rootName = treeRootName;
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        if (rootName == null) {
            rootName = "All " + objTemp.getName() + "s";
        }
        this.rootNode.setUserObject(rootName);
        this.filter = objFilter;
        this.template = objTemp;
        this.setRootObjects(rootObjs);
    }

    public List getPathObjectsTo(Object obj) {
        ArrayList<Object> selectedObjs = new ArrayList<Object>();
        if (obj != null) {
            TreeNode[] nodes = this.getPathToRoot(new ObjectTreeNode(obj, this.template));
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ObjectTreeNode)) continue;
                ObjectTreeNode node = (ObjectTreeNode)nodes[i];
                selectedObjs.add(node.getObject());
            }
        }
        return selectedObjs;
    }

    public MutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public ObjectTemplate getTemplate() {
        return this.template;
    }

    public List getRootObjects() {
        return this.rootObjects;
    }

    public void setRootObjects(List objects) {
        this.rootObjects = new ArrayList(objects);
        this.rootNode.removeAllChildren();
        for (Object o : this.rootObjects) {
            if (this.filter != null && !this.filter.accept(o)) continue;
            this.rootNode.add(this.createObjectTreeNode(o));
        }
        this.reload();
    }

    protected MutableTreeNode createObjectTreeNode(Object node) {
        List children = this.template.getObjectChildren(node, this.filter);
        Iterator i = children.iterator();
        ObjectTreeNode treeNode = new ObjectTreeNode(node, this.template);
        while (i.hasNext()) {
            Object child = i.next();
            if (this.filter != null && !this.filter.accept(child)) continue;
            treeNode.add(this.createObjectTreeNode(child));
        }
        return treeNode;
    }

    public void updateObjectTreeNode(ObjectTreeNode node) {
        node.removeAllChildren();
        List children = this.template.getObjectChildren(node.getUserObject(), this.filter);
        for (Object child : children) {
            if (this.filter != null && !this.filter.accept(child)) continue;
            node.add(this.createObjectTreeNode(child));
        }
    }

    public ObjectFilter getObjectFilter() {
        return this.filter;
    }

    public void setObjectFilter(ObjectFilter objFilter) {
        this.filter = objFilter;
        this.updateViews();
    }

    public void updateViews() {
        this.setRootObjects(this.rootObjects);
    }
}

