/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ObjectTree
extends JTree {
    public Signal objectSelected = Signals.createSignal(Object.class, (String)"objectSelected");

    public ObjectTree(DefaultTreeModel model) {
        super(model);
        this.addTreeSelectionListener(new InnerTreeListener());
    }

    public Object extractUserObjectFromTreePath(TreePath path) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)obj;
            obj = newNode.getUserObject();
        }
        return obj;
    }

    public Object getSelectedObject() {
        TreePath path = this.getLeadSelectionPath();
        if (path != null) {
            return this.extractUserObjectFromTreePath(path);
        }
        return null;
    }

    public boolean setSelectedObject(Object obj) {
        return this.setSelectedObject(obj, (TreeNode)this.getModel().getRoot());
    }

    public boolean setSelectedObject(Object obj, TreeNode toSearchFrom) {
        return this.setSelectedObject(obj, toSearchFrom, Collections.EMPTY_LIST);
    }

    public boolean setSelectedObject(Object obj, TreeNode toSearchFrom, List nodesToExcludeFromSearch) {
        DefaultTreeModel model = this.getModel();
        Object[] path = this.search(toSearchFrom, obj, nodesToExcludeFromSearch);
        if (path != null) {
            TreePath treePath = new TreePath(path);
            if (this.getExpandsSelectedPaths()) {
                this.scrollPathToVisible(treePath);
            }
            this.setSelectionPath(treePath);
        }
        return path != null;
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    protected TreeNode[] search(TreeNode node, Object object) {
        return this.search(node, object, Collections.EMPTY_LIST);
    }

    protected TreeNode[] search(TreeNode node, Object object, List nodesToExclude) {
        TreeNode[] path = null;
        Object obj = node;
        if (node instanceof DefaultMutableTreeNode) {
            if (this.checkContains(nodesToExclude, obj)) {
                return path;
            }
            obj = ((DefaultMutableTreeNode)node).getUserObject();
        }
        if (obj.equals(object)) {
            path = this.getModel().getPathToRoot(node);
        } else {
            int n = this.getModel().getChildCount(node);
            for (int i = 0; i < n && path == null; ++i) {
                path = this.search((TreeNode)this.getModel().getChild(node, i), object, nodesToExclude);
            }
        }
        return path;
    }

    private boolean checkContains(List nodesToExclude, Object obj) {
        for (Object excluded : nodesToExclude) {
            if (!this.containsEqualsCondition(excluded, obj)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsEqualsCondition(Object excluded, Object obj) {
        return obj.equals(excluded);
    }

    public TreeNode searchNode(String nodeStr) {
        DefaultMutableTreeNode node = null;
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!nodeStr.equals(node.getUserObject().toString())) continue;
            return node;
        }
        return null;
    }

    private class InnerTreeListener
    implements TreeSelectionListener {
        private InnerTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newPath = e.getNewLeadSelectionPath();
            if (newPath != null) {
                ObjectTree.this.objectSelected.emit(ObjectTree.this.extractUserObjectFromTreePath(newPath));
            }
        }
    }
}

