/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import javax.swing.Icon;
import javax.swing.JComponent;
import officemate.adminkit.tree.ObjectMenuItem;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.SecurityDecorator;

public class SecurityMenuItem
extends ObjectMenuItem
implements SecurityDecorator {
    private Permission permission;
    private boolean securityOn = true;
    private boolean securityEnabled = true;
    private boolean businessEnabled = true;
    private boolean securityVisible = true;
    private boolean businessVisible = true;

    public SecurityMenuItem(Object value, Permission perm) {
        super(value);
        this.permission = perm;
    }

    public SecurityMenuItem(Object value, Icon icon, Permission perm) {
        super(value);
        this.setIcon(icon);
        this.permission = perm;
    }

    public JComponent getDecorateComponent() {
        return this;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission perm) {
        this.permission = perm;
    }

    public void setSecurityOn(boolean on) {
        this.securityOn = on;
        this.processChanges();
    }

    private void processChanges() {
        boolean enabled;
        boolean bl = this.securityOn ? this.securityEnabled && this.businessEnabled : (enabled = this.businessEnabled);
        boolean visible = this.securityOn ? this.securityVisible && this.businessVisible : this.businessVisible;
        super.setEnabled(enabled);
        super.setVisible(visible);
    }

    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
        this.processChanges();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.businessEnabled = enabled;
        this.processChanges();
    }

    public void setSecurityVisible(boolean visible) {
        this.securityVisible = visible;
        this.processChanges();
    }

    @Override
    public void setVisible(boolean visible) {
        this.businessVisible = visible;
        this.processChanges();
    }
}

