/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.util.Assert;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.ArrayFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;

public class ArrayFieldType
implements FieldType {
    private FieldType elementType;
    private int arrayLength;
    private boolean fixedLength = false;
    private boolean allowEmpty = true;

    public ArrayFieldType(FieldType elmntType) {
        this.elementType = elmntType;
        this.arrayLength = -1;
        this.fixedLength = false;
    }

    public ArrayFieldType(FieldType elmntType, boolean canBeEmpty) {
        this.elementType = elmntType;
        this.arrayLength = -1;
        this.fixedLength = false;
        this.allowEmpty = canBeEmpty;
    }

    public ArrayFieldType(FieldType elmntType, int length) {
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"Array length must be greater than zero");
        this.elementType = elmntType;
        this.arrayLength = length;
        this.fixedLength = false;
    }

    public ArrayFieldType(FieldType elmntType, int length, boolean fixedLen) {
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"Array length must be greater than zero");
        this.elementType = elmntType;
        this.arrayLength = length;
        this.fixedLength = fixedLen;
    }

    public FieldType getElementType() {
        return this.elementType;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public boolean isArbitraryLength() {
        return this.arrayLength == -1;
    }

    public void setArbitraryLength() {
        this.arrayLength = -1;
    }

    public boolean isFixedLength() {
        return !this.isArbitraryLength() && this.fixedLength;
    }

    public void setFixedLength(boolean b) {
        Assert.isTrue((!this.isArbitraryLength() ? 1 : 0) != 0, (String)"Can't set an arbitrary length array to be fixed length.");
        this.fixedLength = b;
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return null;
    }

    @Override
    public Class getJavaClass() {
        return Vector.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return new Vector();
    }

    public String toString() {
        return "List";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        ArrayFieldPanel panel = new ArrayFieldPanel(manager);
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        boolean valid = false;
        if (value != null && value instanceof List) {
            valid = !this.allowEmpty ? ((List)value).size() > 0 : true;
        }
        return valid;
    }
}

