/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.util.Stringifier;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.Enum;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.EnumFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;

public class EnumFieldType
implements FieldType {
    public static final int STYLE_COMBO = 0;
    public static final int STYLE_RADIO_HORIZ = 1;
    public static final int STYLE_RADIO_VERT = 2;
    private Enum myEnum;
    private Object defaultValue;
    private int style = 0;
    private Stringifier stringifier;
    private Stringifier ttStringifier;

    public EnumFieldType(Enum newEnum) {
        if (newEnum == null) {
            throw new IllegalArgumentException("Enum must not be null");
        }
        this.myEnum = newEnum;
        this.defaultValue = this.myEnum.getFirst();
    }

    public EnumFieldType(Enum newEnum, int enumStyle) {
        this(newEnum);
        if (enumStyle < 0 || enumStyle > 2) {
            throw new IllegalArgumentException("Unrecognised style constant: " + enumStyle);
        }
        this.style = enumStyle;
    }

    public EnumFieldType(Enum newEnum, int enumStyle, Object defaultVal) {
        this(newEnum, enumStyle);
        if (!newEnum.hasValue(defaultVal)) {
            throw new IllegalArgumentException("Unexpected value, enum \"" + newEnum.getName() + "\" does not contain value: " + defaultVal);
        }
        this.defaultValue = defaultVal;
    }

    public Stringifier getStringifier() {
        return this.stringifier;
    }

    public void setStringifier(Stringifier value) {
        this.stringifier = value;
    }

    public Enum getEnum() {
        return this.myEnum;
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        JComboBox<Object> comboBox = new JComboBox<Object>(this.myEnum.getValues().toArray());
        return new DefaultCellEditor(comboBox);
    }

    @Override
    public Object getDefaultInitValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "Enum";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        EnumFieldPanel panel = new EnumFieldPanel();
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value != null && this.myEnum.hasValue(value.toString());
    }

    public Stringifier getToolTipStringifier() {
        return this.ttStringifier;
    }

    public void setToolTipStringifier(Stringifier stringy) {
        this.ttStringifier = stringy;
    }
}

