/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.IntCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.IntFieldPanel;
import officemate.adminkit.types.FieldType;

public class IntFieldType
implements FieldType {
    private Integer min;
    private Integer max;
    private Integer def;
    private boolean allowNull = false;

    public IntFieldType() {
        this.def = null;
        this.max = null;
        this.min = null;
    }

    public IntFieldType(int defaultVal) {
        this.def = new Integer(defaultVal);
        this.max = null;
        this.min = null;
    }

    public IntFieldType(int minVal, int maxVal, int defaultVal) {
        this.min = new Integer(minVal);
        this.max = new Integer(maxVal);
        this.def = new Integer(defaultVal);
    }

    public IntFieldType(int minVal, int maxVal, int defaultVal, boolean allowNullVal) {
        this(minVal, maxVal, defaultVal);
        this.allowNull = allowNullVal;
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return new IntCellEditor(this);
    }

    public Integer getMinValue() {
        return this.min;
    }

    public Integer getMaxValue() {
        return this.max;
    }

    public Integer getDefaultValue() {
        return this.def;
    }

    @Override
    public Class getJavaClass() {
        return Integer.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return this.def != null ? this.def : new Integer(0);
    }

    public String toString() {
        return "Integer";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        IntFieldPanel panel = new IntFieldPanel();
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        if (value != null && value instanceof Integer) {
            return true;
        }
        return value == null && this.allowNull;
    }
}

