/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.util.Pair;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.PairListFieldPanel;
import officemate.adminkit.types.FieldType;

public class KVPairFieldType
implements FieldType {
    private FieldType keyType;
    private FieldType valueType;
    private String mappingName;
    private String keyName;
    private String valueName;
    private String keyDescription;
    private String valueDescription;
    private boolean editKey;
    private boolean editValue;
    private Class objEditorClass = null;
    private ObjectTemplate pairTemplate;

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return null;
    }

    public KVPairFieldType(String nameOfMapping, FieldType keyFieldType, String keyFieldName, FieldType valueFieldType, String valueFieldName) {
        this(nameOfMapping, keyFieldType, keyFieldName, valueFieldType, valueFieldName, null);
    }

    public KVPairFieldType(String nameOfMapping, FieldType keyFieldType, String keyFieldName, FieldType valueFieldType, String valueFieldName, Class objectEditorClass) {
        this(nameOfMapping, keyFieldType, keyFieldName, "", true, valueFieldType, valueFieldName, "", true, objectEditorClass);
    }

    public KVPairFieldType(String nameOfMapping, FieldType keyFieldType, String keyFieldName, String keyDesc, FieldType valueFieldType, String valueFieldName, String valDesc, Class objectEditorClass) {
        this(nameOfMapping, keyFieldType, keyFieldName, keyDesc, true, valueFieldType, valueFieldName, valDesc, true, objectEditorClass);
    }

    public KVPairFieldType(String nameOfMapping, FieldType keyFieldType, String keyFieldName, String keyDesc, boolean allowEditKey, FieldType valueFieldType, String valueFieldName, String valDesc, boolean allowEditValue, Class objectEditorClass) {
        this.mappingName = nameOfMapping;
        this.objEditorClass = objectEditorClass;
        this.keyDescription = keyDesc;
        this.valueDescription = valDesc;
        this.keyType = keyFieldType;
        this.valueType = valueFieldType;
        this.valueName = valueFieldName;
        this.keyName = keyFieldName;
        this.editKey = allowEditKey;
        this.editValue = allowEditValue;
        this.pairTemplate = new ObjectTemplate(this.mappingName, Pair.class);
        this.pairTemplate.addEntry(keyFieldName, keyFieldType, "key", keyDesc);
        this.pairTemplate.addEntry(valueFieldName, valueFieldType, "val", valDesc);
    }

    public FieldType getKeyType() {
        return this.keyType;
    }

    public FieldType getValueType() {
        return this.valueType;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getKeyDescription() {
        return this.keyDescription;
    }

    public String getValueDescription() {
        return this.valueDescription;
    }

    public boolean allowEditKey() {
        return this.editKey;
    }

    public boolean allowEditValue() {
        return this.editValue;
    }

    @Override
    public Class getJavaClass() {
        return Pair.class;
    }

    public ObjectTemplate getKVPairTemplate() {
        return this.pairTemplate;
    }

    @Override
    public Object getDefaultInitValue() {
        return new Pair(this.keyType.getDefaultInitValue(), this.valueType.getDefaultInitValue());
    }

    public String toString() {
        return this.mappingName;
    }

    public Class getKVPairEditorClass() {
        return this.objEditorClass != null ? this.objEditorClass : DefaultObjectEditorPanel.class;
    }

    public void setKVPairEditorClass(Class objectEditorClass) {
        this.objEditorClass = objectEditorClass;
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        PairListFieldPanel panel = new PairListFieldPanel(manager);
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() > 0) {
                Object first = list.get(0);
                if (first instanceof Pair) {
                    Pair pair = (Pair)first;
                    boolean keyValid = this.keyType.isValidValue(pair.getKey());
                    boolean valueValid = this.valueType.isValidValue(pair.getValue());
                    return keyValid && valueValid;
                }
            } else {
                return true;
            }
        }
        return value != null && value instanceof Pair && this.keyType.isValidValue(((Pair)value).key) && this.valueType.isValidValue(((Pair)value).value);
    }
}

