/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.reflect.ReflectUtils;
import au.com.ordermate.util.Assert;
import java.awt.Color;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.search.SearchPanel;
import officemate.adminkit.types.FieldType;
import ordermate.OrderMate;

public class ObjectRefFieldType
implements FieldType {
    private Class searchPanelType;
    private Class refClass;
    private boolean allowEdit;
    private boolean allowNew;
    private boolean allowNull;
    private boolean allowSearch;
    private boolean singleObjectOnly;

    public ObjectRefFieldType(Class expectedClass) {
        this(expectedClass, false, false, true, null);
    }

    public ObjectRefFieldType(Class expectedClass, boolean allowsEdit, boolean allowsNew, boolean allowsNull, Class searchPanelClass) {
        this.refClass = expectedClass;
        this.allowEdit = allowsEdit;
        this.allowNew = allowsNew;
        this.allowNull = allowsNull;
        this.allowSearch = searchPanelClass != null;
        Assert.isTrue((searchPanelClass == null || SearchPanel.class.isAssignableFrom(searchPanelClass) ? 1 : 0) != 0, (String)"Search panel class must extend SearchPanel");
        this.searchPanelType = searchPanelClass;
    }

    public ObjectRefFieldType(Class expectedClass, boolean allowsEdit, boolean allowsNew, boolean allowsNull, boolean doAllowSearch) {
        this.refClass = expectedClass;
        this.allowEdit = allowsEdit;
        this.allowNew = allowsNew;
        this.allowNull = allowsNull;
        this.allowSearch = doAllowSearch;
    }

    public ObjectRefFieldType(Class expectedClass, boolean allowsEdit, boolean allowsNew, boolean allowsNull, Class searchPanelClass, boolean singleObject) {
        this(expectedClass, allowsEdit, allowsNew, allowsNull, searchPanelClass);
        this.singleObjectOnly = singleObject;
    }

    public ObjectRefFieldType(Class expectedClass, boolean allowsEdit, boolean allowsNew, boolean allowsNull, boolean doAllowSearch, boolean singleObject) {
        this(expectedClass, allowsEdit, allowsNew, allowsNull, doAllowSearch);
        this.singleObjectOnly = singleObject;
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        List items = objectList;
        if (this.singleObjectOnly) {
            JTextField textField = new JTextField();
            textField.setEditable(false);
            textField.setBackground(Color.WHITE);
            if (!items.isEmpty()) {
                textField.setText(items.get(0).toString());
            }
            return new DefaultCellEditor(textField);
        }
        JComboBox<Object> combo = new JComboBox<Object>(items.toArray());
        return new DefaultCellEditor(combo){
            {
                this.clickCountToStart = 0;
            }
        };
    }

    @Override
    public Class getJavaClass() {
        return this.refClass;
    }

    public boolean isNewAllowed() {
        return this.allowNew;
    }

    public boolean isEditAllowed() {
        return this.allowEdit;
    }

    public boolean isNullAllowed() {
        return this.allowNull;
    }

    public boolean isSearchAllowed() {
        return this.allowSearch;
    }

    public boolean isSingleObject() {
        return this.singleObjectOnly;
    }

    public SearchPanel getSearchPanel() {
        if (this.searchPanelType != null) {
            try {
                return (SearchPanel)this.searchPanelType.newInstance();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Couldn't create search panel, " + this.searchPanelType.getName() + " for finding instances of " + this.refClass.getName(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Object getDefaultInitValue() {
        return null;
    }

    public String toString() {
        return ReflectUtils.getShortClassName((Class)this.refClass);
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        ObjectRefFieldPanel panel = new ObjectRefFieldPanel(manager);
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value == null && this.allowNull || value != null && this.getJavaClass().isAssignableFrom(value.getClass());
    }
}

