/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.util.Price;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.PriceFieldPanel;
import officemate.adminkit.types.FieldType;

public class PriceFieldType
implements FieldType {
    private Double min;
    private Double max;
    private Double def;

    public PriceFieldType() {
        this.def = null;
        this.max = null;
        this.min = null;
    }

    public PriceFieldType(double defaultVal) {
        this.def = new Double(defaultVal);
        this.max = null;
        this.min = null;
    }

    public PriceFieldType(double minVal, double maxVal, double defaultVal) {
        this.min = new Double(minVal);
        this.max = new Double(maxVal);
        this.def = new Double(defaultVal);
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return new DefaultCellEditor(new JTextField());
    }

    public Price getMinValue() {
        return this.min != null ? new Price(this.min.doubleValue(), 0.0) : null;
    }

    public Price getMaxValue() {
        return this.max != null ? new Price(this.max.doubleValue(), 0.0) : null;
    }

    public Price getDefaultValue() {
        return this.def != null ? new Price(this.def.doubleValue(), 0.0) : null;
    }

    @Override
    public Class getJavaClass() {
        return Price.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return new Price(this.def != null ? this.def : 0.0, 0.0);
    }

    public String toString() {
        return "Price";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        PriceFieldPanel panel = new PriceFieldPanel(manager);
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value != null && value instanceof Price;
    }
}

