/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.types.FieldType;
import ordermate.database.config.Quantity;

public class QuantityFieldType
implements FieldType {
    private Quantity min;
    private Quantity max;
    private Quantity def;

    public QuantityFieldType() {
        this.def = null;
        this.max = null;
        this.min = null;
    }

    public QuantityFieldType(Quantity defaultVal) {
        this.def = defaultVal;
        this.max = null;
        this.min = null;
    }

    public QuantityFieldType(Quantity minVal, Quantity maxVal, Quantity defaultVal) {
        this.min = minVal;
        this.max = maxVal;
        this.def = defaultVal;
    }

    public QuantityFieldType(double minVal, double maxVal, double defaultVal) {
        this.min = new Quantity(minVal);
        this.max = new Quantity(maxVal);
        this.def = new Quantity(defaultVal);
    }

    public Quantity getMinValue() {
        return this.min;
    }

    public Quantity getMaxValue() {
        return this.max;
    }

    public Quantity getDefaultValue() {
        return this.def;
    }

    @Override
    public Class getJavaClass() {
        return Quantity.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return this.def != null ? this.def : new Quantity(0.0);
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return new DefaultCellEditor(new JTextField());
    }

    public String toString() {
        return "Double";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        QuantityFieldPanel panel = new QuantityFieldPanel();
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value != null && value instanceof Quantity;
    }
}

