/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.StringFieldPanel;
import officemate.adminkit.types.FieldType;

public class StringFieldType
implements FieldType {
    private String defString = null;
    private boolean allowEmpty = true;

    public StringFieldType() {
    }

    public StringFieldType(String defaultString, boolean allowsEmpty) {
        this.defString = defaultString;
        this.allowEmpty = allowsEmpty;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return this.defString != null ? this.defString : "";
    }

    public boolean isEmptyAllowed() {
        return this.allowEmpty;
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return new EditImmediatelyCellEditor(new NullTextField());
    }

    public String toString() {
        return "Text";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        StringFieldPanel panel = new StringFieldPanel(manager);
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        boolean valid = false;
        if (value == null || value instanceof String) {
            String string = (String)value;
            boolean isEmptyOrNull = string == null || string.length() == 0;
            valid = !isEmptyOrNull || this.allowEmpty;
        }
        return valid;
    }

    protected static class EditImmediatelyCellEditor
    extends DefaultCellEditor {
        public EditImmediatelyCellEditor(JTextField component) {
            super(component);
            this.clickCountToStart = 0;
        }
    }

    protected static class NullTextField
    extends JTextField {
        protected NullTextField() {
        }

        @Override
        public void setText(String text) {
            String actualText = text;
            if (actualText == null) {
                actualText = "";
            }
            super.setText(actualText);
        }

        @Override
        public String getText() {
            String text = super.getText();
            if (text.length() == 0) {
                text = null;
            }
            return text;
        }
    }
}

