/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.wizard;

import au.com.ordermate.persistence.PersistentObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class AbstractWizardState<T extends PersistentObject>
extends JPanel {
    private final AbstractWizardState<T> nextState;
    private JButton back;
    private JButton next;
    private JButton cancel;
    public Signal<T, ?, ?, ?, ?> newObjectReceived;
    public final Signal<?, ?, ?, ?, ?> killObject = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> changeState = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> killWizard = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> previousState = Signals.createSignal();

    public AbstractWizardState(AbstractWizardState<T> theNextState) {
        super(new BorderLayout());
        this.newObjectReceived = Signals.createSignal((Class)((Class)AbstractWizardState.class.getTypeParameters()[0].getBounds()[0]), (String)"newObject");
        this.nextState = theNextState;
        this.initComponents();
        this.addActionListeners();
        JPanel buttonBar = new JPanel();
        buttonBar.add(this.back);
        buttonBar.add(this.cancel);
        buttonBar.add(this.next);
        JPanel centralContent = this.initCentralContent();
        centralContent.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.add((Component)centralContent, "Center");
        this.add((Component)buttonBar, "South");
    }

    public abstract JPanel initCentralContent();

    public abstract String getInstructionText();

    public abstract String getTitleBarText();

    public abstract boolean prepareForStateChange(T var1);

    public abstract void prepareForReturn(T var1);

    private void initComponents() {
        this.back = new JButton("Back");
        this.cancel = new JButton("Cancel");
        this.next = this.nextState == null ? new JButton("Finish") : new JButton("Next");
    }

    private void addActionListeners() {
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizardState.this.previousState.emit();
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizardState.this.changeState.emit();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizardState.this.killWizard.emit();
            }
        });
    }

    public AbstractWizardState<T> getNextState() {
        return this.nextState;
    }
}

