/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.wizard;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.Saveable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Stack;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import officemate.adminkit.wizard.AbstractWizardState;
import org.jdesktop.swingx.JXHeader;

public class GenericWizard<T extends PersistentObject>
extends JDialog {
    private Stack<AbstractWizardState<T>> stateStack;
    private JXHeader header;
    private T object;

    public GenericWizard(AbstractWizardState<T> initialState, Dimension frameSize) {
        super(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        this.createHeader();
        this.header.setTitle(initialState.getInstructionText());
        this.setTitle(initialState.getTitleBarText());
        if (frameSize == null) {
            this.setPreferredSize(new Dimension(450, 300));
            this.setBounds(0, 0, 450, 300);
        } else {
            this.setPreferredSize(frameSize);
            this.setBounds(0, 0, frameSize.width, frameSize.height);
        }
        JFrame parent = GuiApp.getAppComplex().getApplicationFrame().getFrame();
        this.setLocationRelativeTo(parent);
        this.stateStack = new Stack();
        this.connectSignals(initialState);
        this.stateStack.push(initialState);
        this.getContentPane().add((Component)this.header, "North");
        this.getContentPane().add((Component)this.stateStack.peek(), "Center");
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        this.setVisible(true);
    }

    private JPanel createHeader() {
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 3));
        this.header = new JXHeader();
        headerPane.add((Component)this.header);
        headerPane.add(new JSeparator());
        return headerPane;
    }

    protected void updateGUI(AbstractWizardState toRemove) {
        this.remove(toRemove);
        this.add(this.stateStack.peek());
        this.setTitle(this.stateStack.peek().getTitleBarText());
        this.header.setTitle(this.stateStack.peek().getInstructionText());
        this.pack();
        this.validate();
        this.repaint();
    }

    private void saveObject() {
        ((Saveable)this.object).save();
    }

    public T getObject() {
        return this.object;
    }

    private void connectSignals(AbstractWizardState<T> state) {
        state.newObjectReceived.connect((Object)this, "gotNewObject");
        state.killObject.connect((Object)this, "gotKillObject");
        state.changeState.connect((Object)this, "gotStateChanged");
        state.killWizard.connect((Object)this, "killWizard");
        state.previousState.connect((Object)this, "returnToPreviousState");
    }

    private void disconnectSignals(AbstractWizardState<T> state) {
        state.newObjectReceived.disconnectAll();
        state.killObject.disconnectAll();
        state.changeState.disconnectAll();
        state.killWizard.disconnectAll();
        state.previousState.disconnectAll();
    }

    void gotNewObject(T newObject) {
        this.object = newObject;
    }

    void gotKillObject() {
        this.object = null;
    }

    void gotStateChanged() {
        AbstractWizardState<T> formerState = this.stateStack.peek();
        boolean allowStateChange = formerState.prepareForStateChange(this.object);
        if (!allowStateChange) {
            return;
        }
        this.disconnectSignals(formerState);
        if (formerState.getNextState() == null) {
            this.saveObject();
            this.killWizard();
            return;
        }
        this.stateStack.push(formerState.getNextState());
        this.connectSignals(this.stateStack.peek());
        this.updateGUI(formerState);
    }

    void killWizard() {
        while (!this.stateStack.isEmpty()) {
            this.disconnectSignals(this.stateStack.pop());
        }
        this.stateStack.clear();
        this.setVisible(false);
        this.dispose();
    }

    void returnToPreviousState() {
        if (this.stateStack.size() < 2) {
            this.killWizard();
            return;
        }
        this.disconnectSignals(this.stateStack.peek());
        AbstractWizardState<T> formerState = this.stateStack.pop();
        this.connectSignals(this.stateStack.peek());
        this.stateStack.peek().prepareForReturn(this.object);
        this.updateGUI(formerState);
    }
}

