/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import officemate.components.AddRemovePanel;

public class SearchableAddRemovePanel
extends AddRemovePanel<String> {
    private static final int PANEL_HEIGHT = 5;
    private static final int PANEL_WIDTH = 30;
    private JTextField textFilterForPool;
    private JComboBox comboFilterForPool;
    private HashMap<String, List<String>> sections;
    private ArrayList<String> fullTypeList;

    public SearchableAddRemovePanel(HashMap<String, List<String>> itemLists) {
        super(5, 30);
        this.initFeatures(itemLists);
        this.addComponents();
        this.resetPool();
    }

    private void initFeatures(HashMap<String, List<String>> itemLists) {
        this.initTypeList(itemLists);
        this.initTextField();
        this.initComboBox();
        this.initAddRemoveFeatures();
    }

    private void addComponents() {
        this.add((Component)new JScrollPane(this.poolList), new Rectangle(0, 1, 12, 4));
        this.add((Component)this.addButton, new Rectangle(13, 2, 4, 1));
        this.add((Component)this.removeButton, new Rectangle(13, 3, 4, 1));
        this.add((Component)new JScrollPane(this.addedList), new Rectangle(18, 1, 12, 4));
        this.add((Component)new JLabel("Type:"), new Rectangle(0, 0, 2, 1));
        this.add((Component)this.comboFilterForPool, new Rectangle(2, 0, 4, 1));
        this.add((Component)new JLabel("Search"), new Rectangle(6, 0, 2, 1));
        this.add((Component)this.textFilterForPool, new Rectangle(8, 0, 4, 1));
    }

    private void initTypeList(HashMap<String, List<String>> typeLists) {
        this.sections = typeLists;
        this.fullTypeList = new ArrayList();
        for (Map.Entry<String, List<String>> entry : this.sections.entrySet()) {
            this.fullTypeList.addAll((Collection<String>)entry.getValue());
        }
    }

    private void initTextField() {
        this.textFilterForPool = new JTextField();
        this.textFilterForPool.addActionListener(this);
        this.textFilterForPool.addKeyListener(new KeyStrokeListener());
    }

    private void initComboBox() {
        String[] comboBoxItems = new String[this.sections.size() + 1];
        comboBoxItems[0] = "Any";
        int i = 1;
        for (Map.Entry<String, List<String>> entry : this.sections.entrySet()) {
            comboBoxItems[i] = entry.getKey();
            ++i;
        }
        this.comboFilterForPool = new JComboBox<String>(comboBoxItems);
        this.comboFilterForPool.addActionListener(this);
        this.add((Component)new JLabel("Type:"), new Rectangle(10, 11, 2, 1));
        this.add((Component)this.comboFilterForPool, new Rectangle(10, 12, 2, 2));
    }

    private void initAddRemoveFeatures() {
        this.addButton.setText("Add >");
        this.removeButton.setText("< Remove");
    }

    private void resetPool() {
        this.setPoolList(this.getFullList());
    }

    private List<String> getFullList() {
        ArrayList<String> resultList = new ArrayList();
        if (this.comboFilterForPool.getSelectedItem() == "Any") {
            resultList = this.fullTypeList;
        } else {
            resultList.addAll((Collection)this.sections.get(this.comboFilterForPool.getSelectedItem()));
        }
        return resultList;
    }

    private void filterSearchPoolList() {
        this.resetPool();
        String search = this.textFilterForPool.getText();
        if (search != null && !search.isEmpty()) {
            ArrayList<String> toAdd = new ArrayList<String>();
            for (String label : this.getPoolList()) {
                if (label == null || !StringUtils.containsIgnoreCase((String)label, (String)search)) continue;
                toAdd.add(label);
            }
            this.setPoolList(toAdd);
        }
    }

    public void addActionsToButtons(Action action) {
        if (action != null) {
            this.addButton.addActionListener(action);
            this.removeButton.addActionListener(action);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.comboFilterForPool || e.getSource() == this.textFilterForPool) {
            this.filterSearchPoolList();
        }
    }

    public int getFullTypeListSize() {
        return this.fullTypeList.size();
    }

    public int getPoolListSize() {
        return this.poolList.getSize().height;
    }

    public int getAddedListSize() {
        return this.addedList.getSize().height;
    }

    public HashMap<String, List<String>> getSections() {
        return this.sections;
    }

    public void setComboFilter(int index) {
        this.comboFilterForPool.setSelectedIndex(index);
    }

    public void resetPanel() {
        this.remove(this.added.toArray());
        this.comboFilterForPool.setSelectedIndex(0);
        this.textFilterForPool.setText("");
        this.filterSearchPoolList();
        this.addedList.repaint();
        this.poolList.repaint();
        this.removeButton.doClick();
    }

    private class KeyStrokeListener
    implements KeyListener {
        private KeyStrokeListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            SearchableAddRemovePanel.this.filterSearchPoolList();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

