/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.tree.ObjectTree;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public abstract class TreeFilterPanel<T extends TreeNode>
extends JPanel
implements Refreshable {
    private ISingleValueSearchFilter<Collection<T>> filter;
    private final ObjectTree tree;
    private final EventList<T> rootNodes = new BasicEventList();
    private RootNodeHolder rootNode = new RootNodeHolder();
    private final DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private final Refreshable screenToRefresh;

    public TreeFilterPanel(Refreshable refreshable, ISingleValueSearchFilter<Collection<T>> filterToBind) {
        super(new BorderLayout());
        this.screenToRefresh = refreshable;
        this.filter = filterToBind;
        this.rootNodes.addAll(this.getRootNodes());
        this.tree = this.createTree();
        this.tree.setRootVisible(true);
        this.tree.setModel(this.treeModel);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] paths = e.getPaths();
                if (paths != null) {
                    for (int i = paths.length - 1; i >= 0; --i) {
                        if (e.isAddedPath(paths[i])) {
                            TreeFilterPanel.this.nodeSelected(paths[i]);
                            continue;
                        }
                        TreeFilterPanel.this.nodeDeselected(paths[i]);
                    }
                }
                TreeFilterPanel.this.screenToRefresh.refresh();
            }
        });
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    protected abstract List<T> getRootNodes();

    protected ObjectTree createTree() {
        ObjectTree newTree = new ObjectTree(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        OfficeMateAdminGuiUtils.getInstance().standardTreeSetup(newTree);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/group_red.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/red_folder.png"));
        renderer.setClosedIcon(IconLoader.get((String)"/ordermate/images/red_folder.png"));
        newTree.setCellRenderer(renderer);
        return newTree;
    }

    private void nodeSelected(TreePath path) {
        if (path.getLastPathComponent() == this.rootNode) {
            this.filter.setSearchValue(null);
            this.tree.setSelectionPath(null);
            return;
        }
        Collection currentSelections = (Collection)this.filter.getSearchValue();
        ArrayList values = new ArrayList();
        if (currentSelections != null) {
            values.addAll(currentSelections);
        }
        this.addSelection((TreeNode)path.getLastPathComponent(), values);
        this.filter.setSearchValue(values);
    }

    private void addSelection(T selection, Collection<T> addTo) {
        if (!addTo.contains(selection)) {
            addTo.add(selection);
        }
        if (selection.getChildCount() > 0) {
            for (int i = 0; i < selection.getChildCount(); ++i) {
                this.addSelection(selection.getChildAt(i), addTo);
            }
        }
    }

    private void nodeDeselected(TreePath path) {
        if (path.getLastPathComponent() == this.rootNode) {
            return;
        }
        Collection currentSelection = (Collection)this.filter.getSearchValue();
        ArrayList selections = new ArrayList();
        if (currentSelection != null) {
            selections.addAll(currentSelection);
        }
        this.removeSelection((TreeNode)path.getLastPathComponent(), selections);
        this.filter.setSearchValue(selections);
    }

    private void removeSelection(T selection, Collection<T> removeFrom) {
        removeFrom.remove(selection);
        if (selection.getChildCount() > 0) {
            for (int i = 0; i < selection.getChildCount(); ++i) {
                this.removeSelection(selection.getChildAt(i), removeFrom);
            }
        }
    }

    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.rootNodes, this.getRootNodes());
        this.tree.getModel().setRoot(this.rootNode);
    }

    public ObjectTree getTreeGuiComponent() {
        return this.tree;
    }

    class RootNodeHolder
    implements TreeNode {
        RootNodeHolder() {
        }

        public String toString() {
            return "All";
        }

        public Enumeration children() {
            return new IteratorEnumeration(TreeFilterPanel.this.rootNodes.iterator());
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        public T getChildAt(int childIndex) {
            return (TreeNode)TreeFilterPanel.this.rootNodes.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return TreeFilterPanel.this.rootNodes.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return TreeFilterPanel.this.rootNodes.indexOf((Object)node);
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

