/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import officemate.adminkit.OfficeMateAdminGuiUtils;

public class CheckListComboBox<T> {
    private JComboBox combo = new JComboBox();
    private EventComboBoxModel model;
    private JCheckBoxCellRenderer jCheckBoxCellRenderer;

    public CheckListComboBox(List<T> list) {
        this(list, "");
    }

    public CheckListComboBox(List<T> list, String noneText) {
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.combo);
        this.jCheckBoxCellRenderer = JCheckBoxCellRenderer.install((JComboBox)this.combo, (String)noneText);
        this.model = new EventComboBoxModel(GlazedLists.eventList(list));
        this.combo.setModel(this.model);
        this.combo.invalidate();
    }

    public LinkedHashSet<T> getSelectedElements() {
        return this.jCheckBoxCellRenderer.getSelectedElements();
    }

    public void setSelectedElements(List<T> list) {
        this.jCheckBoxCellRenderer.setSelectedElements(list);
        this.combo.setSelectedItem(this.jCheckBoxCellRenderer.getSelectedElementsString());
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    public EventComboBoxModel getModel() {
        return this.model;
    }

    public void setModel(EventComboBoxModel toUse) {
        this.model = toUse;
        this.combo.setModel(this.model);
        this.combo.invalidate();
    }

    public JCheckBoxCellRenderer getJCheckBoxCellRenderer() {
        return this.jCheckBoxCellRenderer;
    }
}

