/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.gui.ObjectEditedDespatch;
import au.com.ordermate.gui.ObjectEditedListener;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.components.controls.TimeRangePanel;
import ordermate.database.misc.DayPart;
import ordermate.gui.model.NullableEventComboBoxModel;

public class DayPartPanel
extends JPanel
implements ActionListener,
ObjectEditedListener {
    private String NULL_PLACEHOLDER = "<Day Part>";
    private TimeRangePanel rangePanel;
    private JComboBox dayPartCombo;
    private NullableEventComboBoxModel model;
    private final EventList<DayPart> partList = new BasicEventList();
    private boolean changing = false;

    public DayPartPanel(TimeRangePanel yourPanel) {
        if (yourPanel == null) {
            throw new IllegalArgumentException("Cannot have a Day Part Panel without a TimeRangePanel");
        }
        this.rangePanel = yourPanel;
        this.setupComponents();
        ObjectEditedDespatch.getInstance().addListener(DayPart.class, (ObjectEditedListener)this);
        this.rangePanel.addAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DayPartPanel.this.changing) {
                    DayPartPanel.this.reset();
                }
            }
        });
    }

    private void setupComponents() {
        this.model = new NullableEventComboBoxModel(this.partList, (Object)"<Custom>");
        this.refreshList();
        this.dayPartCombo = new JComboBox(this.model);
        this.dayPartCombo.setSelectedItem(this.NULL_PLACEHOLDER);
        this.dayPartCombo.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.dayPartCombo);
        this.add(this.dayPartCombo);
    }

    private void refreshList() {
        try {
            this.partList.getReadWriteLock().writeLock().lock();
            this.partList.clear();
            this.partList.addAll((Collection)PersistenceManager.getObjectList(DayPart.class, (String)Query.select(DayPart.class).orderBy(DayPart.Properties.START_TIME).toString()));
            if (this.partList.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                this.model.prependNullPlaceholder(this.partList);
                this.model.setSelectedItem(null);
            }
        }
        finally {
            this.partList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dayPartCombo && this.dayPartCombo.getSelectedItem() != null) {
            this.changing = true;
            DayPart part = (DayPart)this.model.getSelectedItem();
            if (part != null) {
                this.rangePanel.setAllDay(false);
                this.rangePanel.setFromDate(part.getStartTime());
                this.rangePanel.setToDate(part.getEndTime());
                this.rangePanel.actionPerformed(null);
            }
            this.changing = false;
        }
    }

    public void reset() {
        this.dayPartCombo.setSelectedItem(null);
    }

    public void objectEdited(Class clazz) {
        if (DayPart.class.equals((Object)clazz)) {
            this.dayPartCombo.removeActionListener(this);
            this.refreshList();
            this.dayPartCombo.addActionListener(this);
        }
    }

    public DayPart getSelectedDayPart() {
        return (DayPart)this.dayPartCombo.getSelectedItem();
    }
}

