/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.components.AbstractObjectEditor;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.model.NullableEventComboBoxModel;

public class DimensionsSelectionPanel
extends AbstractObjectEditor
implements ActionListener {
    public static final List<GuiDimensions> DEFAULT_GUIDIMS = new ArrayList<GuiDimensions>(){
        {
            this.add(new GuiDimensions("Widefly WF35", new Dimension(240, 320), 12, 25.0));
            this.add(new GuiDimensions("Xplore DT431", new Dimension(272, 480), 12, 35.0));
            this.add(new GuiDimensions("Widefly WF43", new Dimension(480, 800), 18, 50.0));
            this.add(new GuiDimensions("iPad", new Dimension(800, 600), 18, 50.0));
        }
    };
    private String NULL_PLACEHOLDER = "<Custom>";
    private JComboBox resCombo;
    private NullableEventComboBoxModel model;
    private JFormattedTextField widthText;
    private JFormattedTextField heightText;
    private JFormattedTextField fontText;
    private JSpinner iconSpinner;
    private final EventList<GuiDimensions> guiDimList = new BasicEventList();
    private boolean changing = false;

    public DimensionsSelectionPanel(JFormattedTextField width, JFormattedTextField height, JFormattedTextField fontSize, JSpinner iconSize) {
        this.widthText = width;
        this.heightText = height;
        this.fontText = fontSize;
        this.iconSpinner = iconSize;
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DimensionsSelectionPanel.this.changing) {
                    DimensionsSelectionPanel.this.reset();
                }
            }
        };
        this.widthText.addActionListener(action);
        this.heightText.addActionListener(action);
        this.fontText.addActionListener(action);
        this.iconSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DimensionsSelectionPanel.this.changing) {
                    DimensionsSelectionPanel.this.reset();
                }
            }
        });
        JPanel resPanel = new JPanel(new FlowLayout());
        resPanel.add(this.widthText);
        resPanel.add(this.heightText);
        this.resCombo = new JComboBox();
        this.resCombo.setName("DefaultGuiDim");
        this.model = new NullableEventComboBoxModel(this.guiDimList, (Object)this.NULL_PLACEHOLDER);
        this.refreshList();
        this.resCombo.setModel(this.model);
        this.resCombo.setSelectedItem(this.NULL_PLACEHOLDER);
        this.resCombo.addActionListener(this);
        FieldPanelBuilder builder = new FieldPanelBuilder(15);
        builder.addRow("Presets", (Component)this.resCombo);
        builder.addSeparator("");
        builder.addRow("Screen Resolution", (Component)resPanel);
        builder.addRow("Font Size", (Component)fontSize);
        builder.addRow("Icon Size", (Component)iconSize);
        this.add(builder.getPanel());
        this.setBorder(BorderFactory.createEtchedBorder(1));
    }

    private void refreshList() {
        try {
            this.guiDimList.getReadWriteLock().writeLock().lock();
            this.guiDimList.clear();
            this.guiDimList.addAll(DEFAULT_GUIDIMS);
            if (this.guiDimList.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                this.model.prependNullPlaceholder(this.guiDimList);
                this.model.setSelectedItem(null);
            }
        }
        finally {
            this.guiDimList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void reset() {
        this.changing = true;
        this.resCombo.setSelectedItem(null);
        this.changing = false;
    }

    public Dimension getResolution() {
        return ((GuiDimensions)this.resCombo.getSelectedItem()).getResolution();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resCombo && this.resCombo.getSelectedItem() != null) {
            this.changing = true;
            GuiDimensions guiDim = (GuiDimensions)this.model.getSelectedItem();
            if (guiDim != null) {
                this.setResolution(guiDim.getResolution());
                this.setFontSize(guiDim.getFontSize());
                this.setIconScale(guiDim.getIconScale());
            }
            this.changing = false;
        }
    }

    private void setResolution(Dimension res) {
        this.widthText.setText("" + res.width);
        this.heightText.setText("" + res.height);
    }

    private void setFontSize(int size) {
        this.fontText.setText("" + size);
    }

    private void setIconScale(double scale) {
        this.iconSpinner.setValue(scale);
    }

    static class GuiDimensions {
        private String label;
        private Dimension resolution;
        private int fontSize;
        private double iconScale;

        public GuiDimensions(String label, Dimension dim, int font, double icon) {
            this.label = label;
            this.resolution = dim;
            this.fontSize = font;
            this.iconScale = icon;
        }

        public String getLabel() {
            return this.label;
        }

        public Dimension getResolution() {
            return this.resolution;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public double getIconScale() {
            return this.iconScale;
        }

        public String toString() {
            return this.label;
        }
    }
}

