/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class FileSelectionFieldPanel
extends JPanel
implements ActionListener {
    private boolean dirsOnly;
    private FileFilter filter;
    private JButton selectButton;
    private JTextField textField;
    private JFileChooser chooser;
    private List<ChangeListener> changeListeners;

    public FileSelectionFieldPanel() {
        this(20, null, false);
    }

    public FileSelectionFieldPanel(int numCols, FileFilter fileFilter, boolean directoriesOnly) {
        super(new FlowLayout(0, 0, 0));
        this.setupComponents();
        this.textField.setColumns(numCols);
        this.filter = fileFilter;
        this.dirsOnly = directoriesOnly;
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.selectButton.setEnabled(value);
        this.textField.setEnabled(value);
    }

    private void setupComponents() {
        this.selectButton = new JButton("...");
        this.selectButton.getInsets().left = 0;
        this.selectButton.getInsets().right = 0;
        this.selectButton.addActionListener(this);
        this.textField = new JTextField(20);
        this.add(this.textField);
        this.add(this.selectButton);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setText(String value) {
        this.textField.setText(value);
        this.fireChange();
    }

    public String getText() {
        return this.textField.getText();
    }

    public File getSelectedFile() {
        String value = this.textField.getText();
        if (value != null && !value.isEmpty()) {
            return new File(value);
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.textField.getText());
            if (this.filter != null) {
                this.chooser.setFileFilter(this.filter);
            }
            if (this.dirsOnly) {
                this.chooser.setFileSelectionMode(1);
            }
        }
        if (this.chooser.showOpenDialog(this) == 0 && (file = this.chooser.getSelectedFile()) != null) {
            this.setText(file.getAbsolutePath());
            this.fireChange();
        }
    }

    private void fireChange() {
        if (this.changeListeners != null && this.changeListeners.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener listener : this.changeListeners) {
                listener.stateChanged(changeEvent);
            }
        }
    }
}

