/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.components.controls.FileSelectionFieldPanel;

public class IconSelectionPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private FileSelectionFieldPanel fieldPanel;
    private JComboBox predefinedCombo;
    private JLabel previewLabel;
    private Dimension maxDim;

    public IconSelectionPanel() {
        super(null);
        this.setLayout(new BoxLayout(this, 0));
        this.maxDim = new Dimension(22, 22);
        this.setupComponents();
    }

    private void setupComponents() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".png, .jpg", "png", "jpg");
        this.fieldPanel = new FileSelectionFieldPanel(30, filter, false);
        this.predefinedCombo = new JComboBox();
        this.predefinedCombo.setEditable(false);
        this.previewLabel = new JLabel();
        this.previewLabel.setPreferredSize(this.maxDim);
        this.add(this.fieldPanel);
        this.fieldPanel.addChangeListener(this);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.predefinedCombo);
        this.predefinedCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText((String)((Pair)value).getKey());
                }
                return this;
            }
        });
        this.predefinedCombo.setVisible(false);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.previewLabel);
    }

    public void setPredefinedList(List<Pair<String, String>> nameToPathList) {
        this.predefinedCombo.removeActionListener(this);
        if (nameToPathList != null) {
            this.predefinedCombo.setModel(new DefaultComboBoxModel<Object>(nameToPathList.toArray()));
            this.predefinedCombo.setVisible(true);
            this.predefinedCombo.addActionListener(this);
        } else {
            this.predefinedCombo.setVisible(false);
        }
    }

    public JTextField getTextField() {
        return this.fieldPanel.getTextField();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Pair value;
        if (e.getSource() == this.predefinedCombo && (value = (Pair)this.predefinedCombo.getSelectedItem()) != null) {
            this.fieldPanel.setText((String)value.getValue());
        }
    }

    public void updatePreview() {
        String path = this.fieldPanel.getText();
        ImageIcon image = IconLoader.get((String)path);
        if (image != null) {
            image = new ImageIcon(new ImageHelper().fitImageTo(image.getImage(), this.maxDim.width, this.maxDim.height));
        }
        this.previewLabel.setIcon(image);
        this.previewLabel.validate();
        this.previewLabel.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updatePreview();
    }
}

