/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

class NullableColourDialog
extends JDialog
implements ActionListener {
    private JColorChooser chooser;
    private JButton okButton;
    private JButton cancelButton;
    private JButton resetButton;
    private JButton defaultButton;
    private Color chosenColour;

    public NullableColourDialog(JFrame parent) {
        super(parent);
        this.setupComponents();
        this.pack();
    }

    public NullableColourDialog(JDialog parent) {
        super(parent);
        this.setupComponents();
        this.pack();
    }

    public void selectColour(Color color) {
        this.chosenColour = color;
        this.chooser.setColor(color);
        this.setVisible(true);
    }

    private void setupComponents() {
        this.chooser = new JColorChooser();
        this.setTitle("Choose a colour...");
        this.setModal(true);
        this.getContentPane().add((Component)this.chooser, "Center");
        JPanel buttonHolder = new JPanel();
        this.okButton = new JButton(UIManager.getString("ColorChooser.okText"));
        buttonHolder.add(this.okButton);
        this.defaultButton = new JButton("Default");
        buttonHolder.add(this.defaultButton);
        this.cancelButton = new JButton(UIManager.getString("ColorChooser.cancelText"));
        buttonHolder.add(this.cancelButton);
        this.resetButton = new JButton(UIManager.getString("ColorChooser.resetText"));
        buttonHolder.add(this.resetButton);
        this.okButton.addActionListener(this);
        this.defaultButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.getContentPane().add((Component)buttonHolder, "South");
    }

    public Color getSelectedColour() {
        return this.chosenColour;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.resetButton) {
            this.chooser.setColor(this.chosenColour);
            return;
        }
        if (source == this.okButton) {
            this.chosenColour = this.chooser.getColor();
        } else if (source == this.defaultButton) {
            this.chosenColour = null;
        }
        this.setVisible(false);
    }
}

