/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.startup.LoggerSetupTask;

public class PagerPanel
extends JPanel
implements ActionListener {
    private static final int RESOLUTION = 100;
    private final JButton nextButton = new JButton();
    private final JButton lastButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton firstButton = new JButton();
    private JComboBox limitCombo;
    private final JTextField pageTextField = new JTextField();
    private static final int BUTTON_SIZE = 26;
    private final PagerModel listPagerModel;
    private final Refreshable toRefresh;

    public PagerPanel(PagerModel listPager, Refreshable toRefreshOnChange) {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.5f);
        this.setupButton(this.firstButton, "/ordermate/images/1leftarrow.png", "Goto the first page");
        this.setupButton(this.previousButton, "/ordermate/images/1leftarrow.png", "Goto the previous page");
        this.setupTextField();
        this.setupButton(this.nextButton, "/ordermate/images/1rightarrow.png", "Goto the next page");
        this.setupButton(this.lastButton, "/ordermate/images/1rightarrow.png", "Goto the last page");
        DefaultComboBoxModel<Object> boxModel = new DefaultComboBoxModel<Object>(new Object[]{"100", "500", "1000", "5000", "10000", "All"});
        this.limitCombo = new JComboBox<Object>(boxModel);
        this.limitCombo.setEditable(true);
        this.limitCombo.setPreferredSize(new Dimension(104, 26));
        this.limitCombo.setMaximumSize(new Dimension(104, 26));
        this.limitCombo.setName("limitCombo");
        this.add(Box.createHorizontalStrut(5));
        this.add(new JLabel("Rows Per Page"));
        this.add(this.limitCombo);
        this.add(Box.createHorizontalGlue());
        this.listPagerModel = listPager;
        int numPerPage = this.listPagerModel.getElementsPerPage();
        this.limitCombo.setSelectedItem(numPerPage);
        this.toRefresh = toRefreshOnChange;
        this.limitCombo.addActionListener(this);
        this.updateButtonState();
        this.listPagerModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PagerPanel.this.updateButtonState();
            }
        });
    }

    private void updateButtonState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagerPanel.this.previousButton.setEnabled(PagerPanel.this.listPagerModel.hasPreviousPages());
                PagerPanel.this.firstButton.setEnabled(PagerPanel.this.listPagerModel.hasPreviousPages());
                PagerPanel.this.lastButton.setEnabled(PagerPanel.this.listPagerModel.hasMorePages());
                PagerPanel.this.nextButton.setEnabled(PagerPanel.this.listPagerModel.hasMorePages());
                if (PagerPanel.this.listPagerModel.isPaged()) {
                    StringBuilder SB = new StringBuilder();
                    SB.append(PagerPanel.this.listPagerModel.getPageIndex() + 1).append(" of ").append(Math.abs(PagerPanel.this.listPagerModel.getNumPages()));
                    String text = SB.toString();
                    PagerPanel.this.pageTextField.setText(text);
                    PagerPanel.this.pageTextField.setSelectionStart(0);
                    if (SB.toString().length() > 0) {
                        PagerPanel.this.pageTextField.setSelectionEnd(text.length());
                    }
                } else {
                    PagerPanel.this.pageTextField.setText(PagerPanel.this.listPagerModel.getListSize() + " Rows");
                }
            }
        });
    }

    private void setupButton(JButton buttonToSetup, String icon, String toolTip) {
        int INSET = 2;
        buttonToSetup.setIcon(IconLoader.get((String)icon));
        buttonToSetup.setToolTipText(toolTip);
        buttonToSetup.setMargin(new Insets(2, 2, 2, 2));
        buttonToSetup.setMaximumSize(new Dimension(26, 26));
        buttonToSetup.setMinimumSize(new Dimension(26, 26));
        buttonToSetup.setPreferredSize(new Dimension(26, 26));
        buttonToSetup.addActionListener(this);
        this.add(buttonToSetup);
    }

    private void setupTextField() {
        this.pageTextField.setToolTipText("Enter page number");
        this.pageTextField.setMaximumSize(new Dimension(104, 26));
        this.pageTextField.setMinimumSize(new Dimension(104, 26));
        this.pageTextField.setPreferredSize(new Dimension(104, 26));
        this.pageTextField.addActionListener(this);
        this.add(this.pageTextField);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.firstButton == e.getSource()) {
            this.gotFirstButton();
        } else if (this.previousButton == e.getSource()) {
            this.gotPreviousButton();
        } else if (this.nextButton == e.getSource()) {
            this.gotNextButton();
        } else if (this.lastButton == e.getSource()) {
            this.gotLastButton();
        } else if (this.pageTextField == e.getSource()) {
            this.gotPageText();
        } else if (e.getSource() == this.limitCombo) {
            this.updateLimit();
        }
    }

    private void updateLimit() {
        Object value = this.limitCombo.getSelectedItem();
        boolean valid = false;
        if ("All".equals(value)) {
            this.listPagerModel.setElementsPerPage(-1);
            this.updateButtonState();
            this.gotFirstButton();
            return;
        }
        try {
            int intValue = Integer.parseInt(String.valueOf(value));
            int remainder = intValue % 100;
            if (remainder == 0 && intValue >= 100) {
                this.listPagerModel.setElementsPerPage(intValue);
                this.updateButtonState();
                this.gotFirstButton();
                valid = true;
            } else {
                valid = true;
                this.limitCombo.setSelectedItem(intValue += 100 - remainder);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse value to integer:" + value);
        }
        if (!valid) {
            this.limitCombo.setSelectedItem(100);
        }
    }

    private void gotPageText() {
        block4: {
            String text = this.pageTextField.getText().trim();
            if (text.indexOf("of") >= 0) {
                text = text.substring(0, text.indexOf("of")).trim();
            }
            try {
                int pageNumber = Integer.parseInt(text);
                if (this.listPagerModel.hasPage(pageNumber)) {
                    this.listPagerModel.setPageIndex(pageNumber - 1);
                    this.toRefresh.refresh();
                    return;
                }
            }
            catch (NumberFormatException e) {
                if (!Config.isDebuging()) break block4;
                OrderMate.LOG.info("Could not parse :" + text, (Throwable)e);
            }
        }
        this.updateButtonState();
    }

    private void gotLastButton() {
        this.listPagerModel.setPageIndex(this.listPagerModel.getNumPages() - 1);
        this.toRefresh.refresh();
    }

    private void gotNextButton() {
        this.listPagerModel.next();
        this.toRefresh.refresh();
    }

    private void gotPreviousButton() {
        this.listPagerModel.previous();
        this.toRefresh.refresh();
    }

    private void gotFirstButton() {
        this.listPagerModel.setPageIndex(0);
        this.toRefresh.refresh();
    }

    public static void main(String[] args) throws Exception {
        new LoggerSetupTask("test.log").runLocal();
        JFrame frame = new JFrame();
        PagerModel model = new PagerModel(10);
        model.setListSize(100);
        frame.add(new PagerPanel(model, new Refreshable(){

            public void refresh() {
            }
        }));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

