/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.fieldpanels.TimeSpinnerFactory;

public class TimeRangePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private List<Action> actions = new ArrayList<Action>();
    private JSpinner toField;
    private JSpinner fromField;
    private JCheckBox allDayField;

    public TimeRangePanel() {
        super(new FlowLayout(3, 0, 0));
        this.setupComponents();
        this.allDayField.setSelected(true);
        this.fromField.setValue(DateTimeUtils.getStartOfDay((Date)new Date()));
        this.toField.setValue(DateTimeUtils.getEndOfDay((Date)new Date()));
    }

    private void setupComponents() {
        this.allDayField = new JCheckBox();
        this.allDayField.addActionListener(this);
        JPanel toPanel = new JPanel();
        toPanel.add(new JLabel("To"));
        this.toField = TimeSpinnerFactory.create();
        toPanel.add(this.toField);
        JPanel fromPanel = new JPanel();
        fromPanel.add(new JLabel("From"));
        this.fromField = TimeSpinnerFactory.create();
        fromPanel.add(this.fromField);
        this.toField.setEnabled(false);
        this.fromField.setEnabled(false);
        this.toField.addChangeListener(this);
        this.fromField.addChangeListener(this);
        this.add(this.allDayField);
        this.add(fromPanel);
        this.add(toPanel);
    }

    public void setFromDate(Date newFrom) {
        this.fromField.setValue(newFrom);
    }

    public void setToDate(Date newTo) {
        this.toField.setValue(newTo);
    }

    public void setDates(Date newFrom, Date newTo) {
        this.setFromDate(newFrom);
        this.setToDate(newTo);
    }

    public boolean hasRange() {
        return this.fromField.getValue().equals(this.toField.getValue());
    }

    public Date getFromDate() {
        return (Date)this.fromField.getValue();
    }

    public Date getToDate() {
        return (Date)this.toField.getValue();
    }

    public boolean getAllDay() {
        return this.allDayField.isSelected();
    }

    public void setAllDay(boolean allDay) {
        this.allDayField.setSelected(allDay);
        this.toField.setEnabled(!this.getAllDay());
        this.fromField.setEnabled(!this.getAllDay());
    }

    public void addAction(Action newAction) {
        if (newAction != null) {
            this.actions.add(newAction);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toField.setEnabled(!this.getAllDay());
        this.fromField.setEnabled(!this.getAllDay());
        for (Action action : this.actions) {
            action.actionPerformed(new ActionEvent(this, 0, "commit"));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (Action action : this.actions) {
            action.actionPerformed(new ActionEvent(this, 0, "commit"));
        }
    }
}

