/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.renderers;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.tree.TreeNode;

public class TreeNodeListCellRenderer
extends DefaultListCellRenderer {
    private static final int INDENT_DEPTH = 10;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        JComponent comp = renderer;
        if (value == null) {
            return renderer;
        }
        if (value instanceof TreeNode) {
            TreeNode group = (TreeNode)value;
            if (group.getChildCount() > 0) {
                renderer.setIcon(IconLoader.get((String)"/ordermate/images/blue_folder.png"));
            } else {
                renderer.setIcon(IconLoader.get((String)"/ordermate/images/group_blue.png"));
            }
            if (group.getParent() != null) {
                comp = new Box(0);
                int depth = this.calcDepth(group);
                comp.add(Box.createHorizontalStrut(10 * depth));
                comp.add((Component)renderer, "Center");
            }
        }
        return comp;
    }

    protected int calcDepth(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot calculate depth of null node");
        }
        int count = 0;
        while (node.getParent() != null) {
            ++count;
            node = node.getParent();
        }
        return count;
    }
}

