/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.refreshstrategy.RefreshStrategy;

public abstract class AbstractRefreshStrategy<T extends PersistentObjectI>
implements RefreshStrategy {
    protected ObjectPropertySearch<T> objPropSearch;
    private boolean showProgressDialog = false;

    protected AbstractRefreshStrategy(ObjectPropertySearch<T> search) {
        this.objPropSearch = search;
    }

    public void setShowProgressDialog(boolean toSet) {
        this.showProgressDialog = toSet;
    }

    protected ObjectPropertySearch<T> getSearcher() {
        return this.objPropSearch;
    }

    protected ObjectQuerySearcher<T> getPropertySearcher() {
        return this.getSearcher().getPropertySearcher();
    }

    protected List<SearchGuiField> getSearchFields() {
        return this.getSearcher().getSearchFields();
    }

    protected ExecutorService getDatabaseAccessService() {
        return this.getSearcher().getDatabaseAccessService();
    }

    protected void copyIntoObjectList(Collection toInsert) {
        this.getSearcher().copyIntoObjectList(toInsert);
    }

    protected List<T> resolveObjectQuery(ObjectQuery query, Class<T> toReturn) {
        return this.getSearcher().resolveObjectQuery(query, toReturn);
    }

    @Override
    public void doRefresh() {
        if (this.showProgressDialog) {
            Dialogs.showProgressDialog(new AbstractTask(){

                public String getName() {
                    return "Searching...";
                }

                protected void performTask() throws Exception {
                    AbstractRefreshStrategy.this.performRefreshStrategy();
                    this.emitProgress();
                }

                protected int getTotalSubTasks() {
                    return 1;
                }
            });
        } else {
            this.performRefreshStrategy();
        }
    }

    @Override
    public abstract void performRefreshStrategy();
}

