/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SearchPanelBuilder {
    private int pxBetweenField = 10;
    private int pxBetweenCols = 4;
    private int pxBetweenRows = 4;
    private FormLayout layout;
    private PanelBuilder builder;
    private CellConstraints cc;
    private int numFields;
    private int numRows;

    public SearchPanelBuilder(int numOfFields) {
        this.numFields = numOfFields;
        this.clear();
    }

    public void clear() {
        this.numRows = 0;
        String format = "";
        for (int i = 0; i < this.numFields; ++i) {
            format = format + "right:pref, " + this.pxBetweenCols + "px, left:pref," + this.pxBetweenField + "px,";
        }
        this.layout = new FormLayout(format);
        this.builder = new PanelBuilder(this.layout);
        this.builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cc = new CellConstraints();
    }

    public void placeFields(Map fields) {
        this.clear();
        int currentField = 1;
        int currentCol = 1;
        this.addRow();
        for (String text : fields.keySet()) {
            Component comp = (Component)fields.get(text);
            this.placeField(text, comp, currentCol);
            currentCol += 4;
            if (++currentField <= this.numFields) continue;
            ++this.numRows;
            currentField = 1;
            currentCol = 1;
            this.addRow();
        }
    }

    private void placeField(String text, Component comp, int col) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(4);
        label.setLabelFor(comp);
        this.builder.add((Component)label, this.cc.xy(col, this.numRows * 2 + 1));
        this.builder.add(comp, this.cc.xy(col + 2, this.numRows * 2 + 1));
    }

    public void addRow() {
        this.layout.appendRow(new RowSpec("pref"));
        this.layout.appendRow(new RowSpec(this.pxBetweenRows + "px"));
    }

    public JPanel getPanel() {
        return this.builder.getPanel();
    }
}

