/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.searchfield;

import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.Action;
import javax.swing.JPanel;
import officemate.components.controls.DayPartPanel;
import officemate.components.controls.TimeRangePanel;
import ordermate.database.misc.DayPart;
import ordermate.database.sales.itemfilter.TimeSearchFilter;

public class TimeRangeSearchField
extends SearchGuiField {
    private TimeSearchFilter searchProperty;
    private TimeRangePanel timeRangePanel;
    private DayPartPanel dayPartPanel;
    private JPanel holder;

    public TimeRangeSearchField(TimeSearchFilter searchProp, Action refreshAction) {
        this("All Day", searchProp, refreshAction, true);
    }

    public TimeRangeSearchField(String searchFieldLabel, TimeSearchFilter searchProp, Action refreshAction, boolean useDayParts) {
        super(searchFieldLabel, refreshAction);
        this.searchProperty = searchProp;
        if (useDayParts) {
            this.dayPartPanel = new DayPartPanel(this.getTimeRangePanel());
            this.holder = new JPanel();
            this.holder.add(this.getTimeRangePanel());
            this.holder.add(this.dayPartPanel);
        }
    }

    public void addAction(Action action) {
        this.getTimeRangePanel().addAction(action);
    }

    public TimeRangePanel getTimeRangePanel() {
        if (this.timeRangePanel == null) {
            this.timeRangePanel = new TimeRangePanel();
        }
        return this.timeRangePanel;
    }

    public DayPart getSelectedDayPart() {
        if (this.dayPartPanel != null) {
            return this.dayPartPanel.getSelectedDayPart();
        }
        return null;
    }

    public Component getGuiComponent() {
        if (this.holder != null) {
            return this.holder;
        }
        return this.getTimeRangePanel();
    }

    public QuerySearchFilter getSearchProperty() {
        if (this.isEnabled()) {
            if (this.getTimeRangePanel().getAllDay()) {
                this.searchProperty.setAllDay(true);
            } else {
                Calendar fromCal = Calendar.getInstance();
                fromCal.setTime(this.getTimeRangePanel().getFromDate());
                Calendar toCal = Calendar.getInstance();
                toCal.setTime(this.getTimeRangePanel().getToDate());
                this.searchProperty.setStart(fromCal);
                this.searchProperty.setEnd(toCal);
                this.searchProperty.setAllDay(false);
            }
            this.searchProperty.setDayPart(this.getSelectedDayPart());
        } else {
            this.searchProperty.setAllDay(true);
        }
        return this.searchProperty;
    }

    public void reset() {
        this.getTimeRangePanel().setAllDay(true);
        this.getTimeRangePanel().setDates(null, null);
        if (this.dayPartPanel != null) {
            this.dayPartPanel.reset();
        }
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.searchProperty.setAllDay(true);
        }
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

