/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.translator;

import au.com.ordermate.oquery.search.filter.implementation.FullTextJointSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import java.util.HashMap;
import java.util.Map;
import officemate.components.search.translator.FilterTranslator;
import officemate.components.search.translator.FilterTranslatorFactory;
import officemate.components.search.translator.FullTextJointTranslator;
import officemate.components.search.translator.MultiOptionJoinTranslator;
import officemate.components.search.translator.MultiOptionTranslator;
import officemate.components.search.translator.ObjectJoinTranslator;
import officemate.components.search.translator.ObjectTranslator;
import officemate.components.search.translator.RangedSearchTranslator;
import officemate.components.search.translator.TextTranslator;
import officemate.components.search.translator.TimeTranslator;
import ordermate.OrderMate;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.sales.itemfilter.TimeSearchFilter;

public class DefaultFilterTranslatorFactory
implements FilterTranslatorFactory {
    private Map<Class<? extends SearchFilterI>, Object> register = new HashMap<Class<? extends SearchFilterI>, Object>();

    public DefaultFilterTranslatorFactory() {
        this.register.put(FullTextJointSearchFilter.class, FullTextJointTranslator.class);
        this.register.put(ObjectJoinSearchFilter.class, ObjectJoinTranslator.class);
        this.register.put(RangeJoinSearchFilter.class, RangedSearchTranslator.class);
        this.register.put(TradingDayDateRangeFilterAdapter.class, RangedSearchTranslator.class);
        this.register.put(MultiOptionSearchFilter.class, MultiOptionTranslator.class);
        this.register.put(MultiOptionJoinSearchFilter.class, MultiOptionJoinTranslator.class);
        this.register.put(TextSearchFilter.class, TextTranslator.class);
        this.register.put(ObjectSearchFilter.class, ObjectTranslator.class);
        this.register.put(TimeSearchFilter.class, TimeTranslator.class);
    }

    public void registerTranslator(Class<? extends SearchFilterI> filterClazz, Class<? extends FilterTranslator> translatorClazz) {
        this.register.put(filterClazz, translatorClazz);
    }

    @Override
    public FilterTranslator getTranslatorFor(SearchFilterI aFilter) {
        Class<?> filterClazz = aFilter.getClass();
        Object translatorObject = this.register.get(filterClazz);
        if (translatorObject != null && translatorObject instanceof Class) {
            try {
                this.register.put(filterClazz, ((Class)translatorObject).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Cannot do ", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        if ((translatorObject = this.register.get(filterClazz)) == null) {
            throw new IllegalStateException("No Translator object exists for " + filterClazz);
        }
        return (FilterTranslator)translatorObject;
    }
}

