/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.translator;

import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.SearchFilterI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import officemate.components.search.translator.DefaultFilterTranslatorFactory;
import officemate.components.search.translator.FilterTranslator;
import officemate.components.search.translator.SearcherTranslator;

public class DefaultSearcherTranslator
implements SearcherTranslator {
    private DefaultFilterTranslatorFactory factory = new DefaultFilterTranslatorFactory();
    private static final int FONT_SIZE = 10;
    private static final String FONT_TYPE = "arial";
    private JEditorPane infoTextArea;
    private JPanel infoPanel;

    @Override
    public String translateSearcher(AbstractSearcher<? extends PersistentObjectI> searcher) {
        List allFilters = searcher.getUnmodifiableFilters();
        StringBuilder sBuilder = new StringBuilder("<HTML><BODY style=\"font-family:arial;font-size:10px;\">");
        boolean startStringDone = false;
        sBuilder.append("On ").append(searcher.getPersistentClass().getSimpleName());
        for (int i = 0; i < allFilters.size(); ++i) {
            SearchFilterI aFilter = (SearchFilterI)allFilters.get(i);
            if (!aFilter.hasSearchValue()) continue;
            if (startStringDone) {
                sBuilder.append(" and ");
            } else {
                sBuilder.append(" where ");
                startStringDone = true;
            }
            sBuilder.append(this.factory.getTranslatorFor(aFilter).translateFilter(aFilter));
        }
        sBuilder.append("</font></BODY></HTML>");
        return sBuilder.toString();
    }

    public void registerNewTranslator(Class<? extends SearchFilterI> searchClazz, Class<? extends FilterTranslator> translatorClazz) {
        this.factory.registerTranslator(searchClazz, translatorClazz);
    }

    @Override
    public JComponent getGuiComponent() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel(new BorderLayout());
            if (this.infoTextArea == null) {
                this.infoTextArea = new JEditorPane("text/html", "");
                this.infoTextArea.setEditable(false);
                this.infoTextArea.setPreferredSize(new Dimension(100, 40));
                this.infoTextArea.setName("infoText");
                JScrollPane scroller = new JScrollPane(this.infoTextArea);
                scroller.setHorizontalScrollBarPolicy(31);
                this.infoPanel.add(scroller);
            }
        }
        return this.infoPanel;
    }

    @Override
    public void updateTranslation(AbstractSearcher<? extends PersistentObjectI> searcher) {
        if (this.infoTextArea != null) {
            this.infoTextArea.setText(this.translateSearcher(searcher));
        }
    }
}

