/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Displayable;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.EditorDialog;
import officemate.components.strategy.SaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractTableState;
import ordermate.OrderMate;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.users.Permission;
import ordermate.gui.dialogs.ProgressDialog;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;

public abstract class AbstractEditableTableState<T>
extends AbstractTableState<T> {
    private ObjectEditor<T> editor;
    private SaveStrategy<T> saveStrategy;
    private EditorDialog editorDialog;
    private ProgressDialog progressDialog;

    public AbstractEditableTableState() {
        this("", null, "", null);
    }

    public AbstractEditableTableState(String stateName, Permission permission, String description) {
        this(stateName, permission, description, null);
    }

    public AbstractEditableTableState(String stateName, Permission permission, String description, ObjectEditor<T> objEditor) {
        super(stateName, permission, description);
        this.editor = objEditor;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        if (this.supportsEditorDialog()) {
            this.editorDialog = this.createEditorDialog();
        }
        if (this.saveStrategy == null) {
            this.saveStrategy = SaveStrategyFactory.getInstantSaveStrategy();
        }
        this.createActions();
        this.getCentralArea().objectEdited().connect((Object)this, "gotObjectEdited");
        ELProperty unchanged = ELProperty.create((String)"${!changed}");
        BeanProperty enabled = BeanProperty.create((String)"enabled");
        JPanel searchBar = this.getSearchFactory().getSearchPanel();
        AutoBinding changedBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.getSaveStrategy(), (Property)unchanged, (Object)searchBar, (Property)enabled);
        changedBinding.bind();
        this.getSearchFactory().resetSearch();
    }

    protected abstract ObjectEditor<T> createObjectEditor();

    public abstract String getTypeName();

    protected String getObjectLabel(T toGet) {
        if (toGet instanceof Displayable) {
            return ((Displayable)toGet).getLabel();
        }
        return toGet.toString();
    }

    protected void createActions() {
        if (this.supportsEditorDialog()) {
            this.addSelectionDependentAction(this.getEditAction());
        }
        if (this.canCreateOrDelete()) {
            this.addSelectionDependentAction(this.getDeleteAction());
        }
        for (Action action : this.saveStrategy.getActions()) {
            this.addAction(action);
        }
    }

    protected EditorDialog createEditorDialog() {
        return new EditorDialog(this.getTypeName(), this.editor);
    }

    protected T createNewObject() {
        try {
            Object newObject = this.getDisplayingType().newInstance();
            OfficeMateEventLog.getInst().logObjectCreation(newObject, GuiApp.getAppComplex().getApplicationSecurity().getUser());
            return newObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Error constructing new object using reflection", e);
        }
    }

    protected boolean canCreateOrDelete() {
        return true;
    }

    protected boolean isDeleteAllowed(List<T> toDelete) {
        if (toDelete.size() == 1) {
            T deleteObject = toDelete.get(0);
            return Dialogs.showWarningDialog("Really Delete?", "<HTML>Are you sure you want to delete the " + this.getTypeFromObject(toDelete.get(0)) + " '" + this.getObjectLabel(deleteObject) + "'?<P><P>This operation cannot be undone!");
        }
        return Dialogs.showWarningDialog("Really Delete?", "Are you sure you want to delete the " + toDelete.size() + " selected objects?  This operation cannot be undone!");
    }

    protected String getTypeFromObject(Object value) {
        return this.getTypeName();
    }

    private boolean supportsEditorDialog() {
        if (this.editor == null) {
            this.getObjectEditor();
        }
        return this.editor != null;
    }

    @Override
    public void gotObjectDoubleClicked(T toEdit) {
        if (this.supportsEditorDialog()) {
            this.doEdit(this.getCentralArea().getSelectedObject());
        }
    }

    public void gotObjectEdited(T editedObject) {
        this.saveStrategy.objectNeedsSaving(editedObject);
    }

    public void gotObjectDeleted(T deletedObject) {
        this.saveStrategy.objectNeedsDeleting(deletedObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doDialog(T object) {
        if (!this.supportsEditorDialog()) {
            throw new IllegalStateException("doDialog was called but this state does not support editing in a dialog");
        }
        this.progressDialog = Dialogs.createProgressDialog(new LoadEditorTask(object));
        this.progressDialog.start();
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
        if (!this.editorDialog.doModal()) {
            this.editor.revertObject();
            return this.editorDialog.getOkClicked();
        }
        if (!this.isValidForSaving()) {
            this.showCannotSaveDialog();
            return false;
        }
        this.editor.saveObject();
        Object toSave = this.editor.getObject();
        try {
            this.gotObjectEdited(toSave);
            return this.editorDialog.getOkClicked();
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + "" != null ? ": " + ex.getMessage() : "";
            Dialogs.showErrorDialog("Could not save " + this.getTypeName(), "An error occurred whilst saving " + msg);
            OrderMate.LOG.error("Could not save " + this.getTypeName() + " : " + toSave, (Throwable)ex);
            return this.editorDialog.getOkClicked();
        }
    }

    protected boolean isValidForSaving() {
        return true;
    }

    protected void showCannotSaveDialog() {
        Dialogs.showErrorDialog("Cannot Save", "Object cannot be saved!");
    }

    protected boolean gotOkClicked() {
        return this.editorDialog.getOkClicked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(List<T> toDelete) {
        if (this.isDeleteAllowed(toDelete)) {
            ArrayList<T> deleteList = new ArrayList<T>(toDelete);
            EventList objectList = this.getObjectList();
            objectList.getReadWriteLock().writeLock().lock();
            try {
                objectList.removeAll(toDelete);
            }
            finally {
                objectList.getReadWriteLock().writeLock().unlock();
            }
            for (Object nextT : deleteList) {
                this.gotObjectDeleted(nextT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doEdit(T toEdit) {
        if (this.doDialog(toEdit)) {
            EventList objectList = this.getObjectList();
            objectList.getReadWriteLock().writeLock().lock();
            try {
                int index = objectList.indexOf(toEdit);
                if (index > -1) {
                    objectList.set(index, toEdit);
                }
            }
            finally {
                objectList.getReadWriteLock().writeLock().unlock();
            }
            return true;
        }
        return false;
    }

    protected ObjectEditor<T> getObjectEditor() {
        if (this.editor == null) {
            this.editor = this.createObjectEditor();
        }
        return this.editor;
    }

    @Override
    public void doNewAction() {
        block11: {
            if (!this.canCreateOrDelete()) {
                return;
            }
            try {
                T newObj = this.createNewObject();
                if (newObj == null) {
                    return;
                }
                if (this.supportsEditorDialog()) {
                    this.doDialog(newObj);
                } else {
                    this.gotObjectEdited(newObj);
                }
                if (this.supportsEditorDialog() && (!this.editorDialog.getOkClicked() || !this.isValidForSaving())) break block11;
                EventList objectList = this.getObjectList();
                objectList.getReadWriteLock().writeLock().lock();
                objectList.getReadWriteLock().readLock().lock();
                try {
                    if (this.supportsEditorDialog()) {
                        objectList.add(this.editor.getObject());
                    } else {
                        objectList.add(newObj);
                    }
                }
                finally {
                    objectList.getReadWriteLock().writeLock().unlock();
                    objectList.getReadWriteLock().readLock().unlock();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JXTable table = AbstractEditableTableState.this.getCentralArea().getTable();
                        int count = table.getRowCount();
                        if (count > 0) {
                            table.scrollRowToVisible(count - 1);
                        }
                    }
                });
            }
            catch (Exception ex) {
                Dialogs.showErrorDialog("Error occured creating a new " + this.getTypeName(), "<HTML>Could not create a new " + this.getTypeName() + " due to error:<BR>" + ex.getMessage());
                OrderMate.LOG.error("Could not create new " + this.getTypeName(), (Throwable)ex);
            }
        }
    }

    @Override
    public void doEditAction() {
        this.doEdit(this.getCentralArea().getSelectedObject());
    }

    @Override
    public void doDeleteAction() {
        List selected = this.getCentralArea().getAllSelectedObjects();
        this.doDelete(selected);
    }

    @Override
    public boolean supportsNew() {
        return this.canCreateOrDelete();
    }

    public final SaveStrategy<T> getSaveStrategy() {
        return this.saveStrategy;
    }

    public final void setSaveStrategy(SaveStrategy<T> newSaveStrategy) {
        if (this.saveStrategy != null) {
            throw new IllegalStateException("The strategy is already set, it cannot be changed.");
        }
        this.saveStrategy = newSaveStrategy;
    }

    @Override
    public void refresh() {
        this.promptForSave();
        super.refresh();
        if (this.saveStrategy != null) {
            this.saveStrategy.clear();
        }
    }

    @Override
    public boolean isExitAllowed() {
        this.promptForSave();
        return true;
    }

    protected void promptForSave() {
        if (this.saveStrategy != null) {
            this.saveStrategy.promptForSave(this.getScreenPanel());
        }
    }

    public final EditorDialog getEditorDialog() {
        return this.editorDialog;
    }

    class LoadEditorTask
    extends AbstractTask {
        T object;

        LoadEditorTask(T value) {
            this.object = value;
        }

        public String getName() {
            return "Loading...";
        }

        protected void performTask() throws Exception {
            this.emitProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractEditableTableState.this.editor.setObject(LoadEditorTask.this.object);
                }
            });
        }

        protected int getTotalSubTasks() {
            return 2;
        }
    }
}

