/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import officemate.components.table.PersistentObjectTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class EditMultiple
extends JPanel {
    private JPanel holder;
    private JLabel instructions = new JLabel();
    private PersistentObjectTable table;
    private List<EditorWrapper> wrappers;

    public EditMultiple() {
        super(new BorderLayout());
        this.holder = new JPanel();
        this.add((Component)this.instructions, "North");
        this.add((Component)new JScrollPane(this.holder), "Center");
    }

    public void initialise(PersistentObjectTable objectTable, PropertiedObject.Property[] propertiesToExclude) {
        this.holder.removeAll();
        if (objectTable == null) {
            throw new NullPointerException("The table parameter is null.");
        }
        this.table = objectTable;
        this.wrappers = new ArrayList<EditorWrapper>();
        List<TableColumn> columns = this.getIncludedColumnsAsList(propertiesToExclude);
        for (TableColumn column : columns) {
            EditorWrapper wrapper = this.createEditorComponent(column);
            if (wrapper == null) continue;
            this.wrappers.add(wrapper);
        }
        GraphPaperLayout layout = new GraphPaperLayout(22, 2 + 4 * this.wrappers.size());
        this.holder.setLayout((LayoutManager)layout);
        int count = 1;
        for (EditorWrapper wrapper : this.wrappers) {
            this.holder.add((Component)new JLabel(wrapper.label), new Rectangle(1, count, 6, 3));
            this.holder.add((Component)wrapper.enableCheck, new Rectangle(7, count, 2, 3));
            this.holder.add((Component)wrapper.editorComponent, new Rectangle(10, count, 10, 3));
            count += 4;
        }
        this.instructions.setText(this.createInstructions());
    }

    private List<TableColumn> getIncludedColumnsAsList(PropertiedObject.Property[] propertiesToExclude) throws IllegalStateException {
        ArrayList<TableColumnExt> excludedColumns = new ArrayList<TableColumnExt>();
        for (PropertiedObject.Property aPropertiesToExclude : propertiesToExclude) {
            TableColumnExt column = this.table.getTable().getColumnExt((Object)aPropertiesToExclude);
            if (column == null) {
                throw new IllegalStateException("Property to exclude does not exist in table: " + aPropertiesToExclude);
            }
            excludedColumns.add(column);
        }
        ArrayList<TableColumn> includedColumns = new ArrayList<TableColumn>();
        for (TableColumn column : this.table.getTable().getColumns()) {
            if (excludedColumns.contains(column)) continue;
            includedColumns.add(column);
        }
        return includedColumns;
    }

    public void save() {
        for (EditorWrapper wrapper : this.wrappers) {
            if (!wrapper.enableCheck.isSelected()) continue;
            this.saveWrapper(wrapper);
        }
        this.finish();
    }

    protected void saveWrapper(EditorWrapper wrapper) {
        if (wrapper.editor != null) {
            wrapper.editor.stopCellEditing();
        }
        if (wrapper.enableCheck.isSelected()) {
            Object value = wrapper.editor.getCellEditorValue();
            int[] selectedRows = this.table.getTable().getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedRows[i] = this.table.getTable().convertRowIndexToModel(selectedRows[i]);
            }
            for (int selectedRow : selectedRows) {
                this.table.getTable().setValueAt(value, this.table.getTable().convertRowIndexToView(selectedRow), wrapper.column);
            }
        }
    }

    public void finish() {
        for (EditorWrapper wrapper : this.wrappers) {
            wrapper.editorComponent.setEnabled(true);
        }
    }

    protected PersistentObjectTable getTable() {
        return this.table;
    }

    protected EditorWrapper createEditorComponent(TableColumn column) {
        int actualCol = this.table.getTable().convertColumnIndexToView(column.getModelIndex());
        int rowIndex = this.table.getTable().getSelectionModel().getAnchorSelectionIndex();
        TableCellEditor cellEditor = this.table.getTable().getCellEditor(rowIndex, actualCol);
        if (cellEditor == null) {
            cellEditor = this.createCellEditor(column);
        }
        if (cellEditor == null) {
            return null;
        }
        Object defaultVal = this.table.getTable().getValueAt(rowIndex, actualCol);
        JComponent editorComponent = (JComponent)cellEditor.getTableCellEditorComponent((JTable)this.table.getTable(), defaultVal, false, rowIndex, actualCol);
        EditorWrapper wrapper = new EditorWrapper(cellEditor, editorComponent, actualCol, String.valueOf(column.getHeaderValue()));
        return wrapper;
    }

    protected TableCellEditor createCellEditor(TableColumn column) {
        return null;
    }

    public String createInstructions() {
        StringBuilder SB = new StringBuilder("<html><h2>Editing Multiple Items</h2>");
        SB.append("Select the checkbox next to a property to set that property across multiple items.<br>");
        SB.append("You are editing <b>").append(this.table.getTable().getSelectedRows().length).append("</b> rows in the table.");
        SB.append("</html>");
        return SB.toString();
    }

    public class EditorWrapper
    implements ActionListener {
        private final JCheckBox enableCheck = new JCheckBox();
        private final TableCellEditor editor;
        private final JComponent editorComponent;
        private final int column;
        private final String label;

        public EditorWrapper(TableCellEditor editor, JComponent editorComponent, int column, String label) {
            this.enableCheck.addActionListener(this);
            editorComponent.setEnabled(false);
            this.editorComponent = editorComponent;
            this.editor = editor;
            this.column = column;
            this.label = label;
            this.enableCheck.setName("check_" + label);
            editorComponent.setName("component_" + label);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editorComponent.setEnabled(this.enableCheck.isSelected());
        }

        public JCheckBox getEnableCheck() {
            return this.enableCheck;
        }

        public TableCellEditor getEditor() {
            return this.editor;
        }

        public JComponent getEditorComponent() {
            return this.editorComponent;
        }

        public int getColumn() {
            return this.column;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

