/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import officemate.components.tableformat.AbstractEditableColumnFormat;

public class SelectionColumnFormat<T>
extends AbstractEditableColumnFormat {
    private Set<T> selections = new HashSet<T>();
    private SelectionRenderer renderer = new SelectionRenderer();

    public SelectionColumnFormat(String name) {
        super(name, Boolean.TYPE);
        this.setCustomRenderer(this.renderer);
        this.setCustomEditor(new DefaultCellEditor(new JCheckBox()));
    }

    public void clearSelections() {
        this.selections.clear();
        this.renderer.invalidate();
    }

    public void addSelections(Collection<T> newSelections) {
        this.selections.addAll(newSelections);
        this.renderer.invalidate();
    }

    public Set<? extends T> getSelections() {
        return Collections.unmodifiableSet(this.selections);
    }

    public boolean isSelected(Object value) {
        return this.selections.contains(value);
    }

    @Override
    public Object setValue(Object baseObject, Object editedValue) {
        if (baseObject != null && editedValue != null && editedValue instanceof Boolean) {
            if (((Boolean)editedValue).booleanValue()) {
                this.selections.add(baseObject);
            } else {
                this.selections.remove(baseObject);
            }
        }
        return baseObject;
    }

    public Object resolveColumnValue(Object baseObject) {
        return this.selections.contains(baseObject);
    }

    class SelectionRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private JLabel label = new JLabel();

        SelectionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setSelected(Boolean.TRUE.equals(value));
                return this;
            }
            return this.label;
        }
    }
}

