/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import officemate.components.table.SimpleTotalCalculator;
import officemate.components.table.TotalsCalculator;
import ordermate.OrderMate;
import org.apache.commons.beanutils.PropertyUtils;
import org.jdesktop.swingx.JXTable;

public class TotalTableModel
extends AbstractTableModel {
    private TableModel toTotal;
    private JTable tableToTotal;
    private List<String> columnsToIgnore = new ArrayList<String>();
    private TableModelListener listener;
    private SyncColumnModelListener syncListener;
    private TotalsCalculator defaultCalc = new SimpleTotalCalculator();
    private Map<Integer, TotalsCalculator> calculators;

    public TotalTableModel(JTable mainTable, JTable totalsTable) {
        this.tableToTotal = mainTable;
        this.toTotal = this.tableToTotal.getModel();
        this.setupTotalTable(mainTable, totalsTable);
    }

    public void setDefaultCalculator(TotalsCalculator newDefault) {
        this.defaultCalc = newDefault;
    }

    public void setCalculator(Integer column, TotalsCalculator calc) {
        if (this.calculators == null) {
            this.calculators = new HashMap<Integer, TotalsCalculator>();
        }
        this.calculators.put(column, calc);
    }

    public void releaseTable() {
        this.toTotal.removeTableModelListener(this.listener);
        this.tableToTotal.getColumnModel().removeColumnModelListener(this.syncListener);
        this.toTotal = null;
        this.tableToTotal = null;
    }

    public void setColumnsToIgnore(Collection<String> columnNames) {
        this.columnsToIgnore.clear();
        this.columnsToIgnore.addAll(columnNames);
    }

    protected TableModel getTableModel() {
        return this.toTotal;
    }

    @Override
    public int getColumnCount() {
        return this.toTotal.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableModel model = this.getTableModel();
        int realColumn = this.getRealColumnIndex(columnIndex);
        if (realColumn < 0 || realColumn >= model.getColumnCount()) {
            return null;
        }
        TotalsCalculator calc = this.defaultCalc;
        if (this.calculators != null && this.calculators.containsKey(realColumn)) {
            calc = this.calculators.get(realColumn);
        }
        Class<?> type = model.getColumnClass(realColumn);
        if (!this.columnsToIgnore.contains(model.getColumnName(realColumn)) && Number.class.isAssignableFrom(type)) {
            Number value = calc.calculateTotal(model, this, realColumn);
            if (value != null) {
                return this.buildNewNumber(type, value.doubleValue());
            }
            return this.buildNewNumber(type, 0.0);
        }
        return "-";
    }

    protected int getRealColumnIndex(int columnIndex) {
        return columnIndex;
    }

    private Number buildNewNumber(Class type, double value) {
        if (type.isAssignableFrom(Integer.class)) {
            return (int)value;
        }
        if (type.isAssignableFrom(Double.class)) {
            return value;
        }
        if (type.isAssignableFrom(Price.class)) {
            return new Price(value, 0.01);
        }
        if (type.isAssignableFrom(Long.class)) {
            return (long)value;
        }
        return null;
    }

    public void setupTotalTable(JTable mainTable, JTable totalTable) {
        totalTable.setModel(this);
        totalTable.setAutoResizeMode(0);
        this.listener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TotalTableModel.this.fireTableChanged(e);
            }
        };
        this.toTotal.addTableModelListener(this.listener);
        this.syncListener = new SyncColumnModelListener(totalTable.getColumnModel());
        mainTable.getColumnModel().addColumnModelListener(this.syncListener);
    }

    public static final Component createTotalTable(JXTable mainTable) {
        JTable totalsTable = new JTable();
        new TotalTableModel((JTable)mainTable, totalsTable);
        return totalsTable;
    }

    private static class SyncColumnModelListener
    implements TableColumnModelListener {
        private TableColumnModel modelToSyncTo;

        public SyncColumnModelListener(TableColumnModel newToSync) {
            this.modelToSyncTo = newToSync;
        }

        @Override
        public void columnAdded(TableColumnModelEvent event) {
            TableColumnModel eventModel = (TableColumnModel)event.getSource();
            TableColumn addedCol = eventModel.getColumn(event.getToIndex());
            try {
                TableColumn cloneCol = (TableColumn)addedCol.getClass().newInstance();
                PropertyUtils.copyProperties((Object)cloneCol, (Object)addedCol);
                this.modelToSyncTo.addColumn(cloneCol);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error adding column to total table", (Throwable)e);
            }
            this.reSyncColWidth(eventModel);
        }

        @Override
        public void columnMarginChanged(ChangeEvent event) {
            TableColumnModel eventModel = (TableColumnModel)event.getSource();
            this.reSyncColWidth(eventModel);
        }

        private void reSyncColWidth(TableColumnModel eventModel) {
            int columnCount = eventModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.modelToSyncTo.getColumn(i).setWidth(eventModel.getColumn(i).getWidth());
                if (i < columnCount - 1) {
                    this.modelToSyncTo.getColumn(i).setMaxWidth(eventModel.getColumn(i).getWidth());
                    this.modelToSyncTo.getColumn(i).setMinWidth(eventModel.getColumn(i).getWidth());
                    this.modelToSyncTo.getColumn(i).setPreferredWidth(eventModel.getColumn(i).getWidth());
                    continue;
                }
                this.modelToSyncTo.getColumn(i).setMaxWidth(eventModel.getColumn(i).getMaxWidth());
                this.modelToSyncTo.getColumn(i).setMinWidth(eventModel.getColumn(i).getMinWidth());
                this.modelToSyncTo.getColumn(i).setPreferredWidth(eventModel.getColumn(i).getPreferredWidth());
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent event) {
            TableColumnModel eventModel = (TableColumnModel)event.getSource();
            this.modelToSyncTo.moveColumn(event.getFromIndex(), event.getToIndex());
            this.reSyncColWidth(eventModel);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent event) {
            TableColumnModel eventModel = (TableColumnModel)event.getSource();
            this.modelToSyncTo.removeColumn(this.modelToSyncTo.getColumn(event.getFromIndex()));
            this.reSyncColWidth(eventModel);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

