/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.text.Format;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.EditorDialog;
import officemate.components.ListPropertyObjectEditor;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AbstractDialogCellEditor;
import ordermate.reports.table.AbstractColumnFormat;

public class PopupEditableColumnFormat
extends EditablePropertyColumnFormat {
    private Format formater;
    private ObjectEditor editor;
    private BasicOfficeMateState state;

    public PopupEditableColumnFormat(PropertiedObject.Property listProp, ObjectEditor newEditor, BasicOfficeMateState parentState) {
        super(listProp);
        this.editor = newEditor;
        this.setCustomRenderer(new ListCellRenderer());
        this.setCustomEditor(new PopupCellEditor());
        this.state = parentState;
    }

    private Object getPropValue(Object baseObject) {
        Object value = super.resolveColumnValue(baseObject);
        if (this.formater != null) {
            value = this.formater.format(value);
        }
        return value;
    }

    public String getStringValue(Object baseObject) {
        Object value = this.getPropValue(baseObject);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public AbstractColumnFormat setFormatter(Format newFormat) {
        this.formater = newFormat;
        return this;
    }

    public Object resolveColumnValue(Object baseObject) {
        return baseObject;
    }

    @Override
    public Object setValue(Object baseObject, Object editedValue) {
        super.setValue(baseObject, editedValue);
        return baseObject;
    }

    private class ListCellRenderer
    extends DefaultTableCellRenderer {
        private ListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object toDisplay = PopupEditableColumnFormat.this.getPropValue(value);
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, toDisplay, isSelected, hasFocus, row, column);
            return renderer;
        }
    }

    private class PopupCellEditor
    extends AbstractDialogCellEditor {
        public PopupCellEditor() {
            super(new JButton());
        }

        @Override
        public void setupButton(Object value, AbstractButton theButton) {
            super.setupButton(value, theButton);
            theButton.setText(PopupEditableColumnFormat.this.getStringValue(value));
        }

        @Override
        public Object doDialog() {
            EditorDialog dialog = new EditorDialog(PopupEditableColumnFormat.this.editor);
            PopupEditableColumnFormat.this.editor.setObject(PopupEditableColumnFormat.this.resolveColumnValue(this.getCurrentValue()));
            dialog.doModal();
            Collection toReturn = null;
            if (dialog.getOkClicked()) {
                PopupEditableColumnFormat.this.editor.saveObject();
                toReturn = PopupEditableColumnFormat.this.editor instanceof ListPropertyObjectEditor ? ((ListPropertyObjectEditor)PopupEditableColumnFormat.this.editor).getGuiList() : PopupEditableColumnFormat.this.editor.getObject();
                toReturn = toReturn == null ? NULL_OBJECT : toReturn;
            } else {
                PopupEditableColumnFormat.this.editor.revertObject();
            }
            return toReturn;
        }
    }
}

