/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat;

import au.com.ordermate.persistence.PropertiedObject;
import java.text.Format;
import ordermate.OrderMate;
import ordermate.reports.table.AbstractColumnFormat;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyArrayColumnFormat
extends AbstractColumnFormat {
    private PropertiedObject.Property prop;
    private int index;
    private String id;

    public PropertyArrayColumnFormat(PropertiedObject.Property property, int index, String newName, Class newColClass) {
        this(property, index, newName, newColClass, null);
    }

    public PropertyArrayColumnFormat(PropertiedObject.Property property, int index, String newName, Class newColClass, Format format) {
        super(newName, newColClass, format);
        this.prop = property;
        this.index = index;
        this.id = this.prop.getName() + "[" + index + "]";
    }

    public PropertiedObject.Property getProperty() {
        return this.prop;
    }

    public Object getIdentifier() {
        return this.id;
    }

    public Object resolveColumnValue(Object baseObject) {
        try {
            Object[] value = (Object[])PropertyUtils.getProperty((Object)baseObject, (String)this.prop.getName());
            if (value != null && this.index < value.length) {
                return value[this.index];
            }
            return null;
        }
        catch (Exception e) {
            StringBuilder SB = new StringBuilder("Error resolving property value for ");
            SB.append(this.prop).append(" in obj : ").append(baseObject).append(" with type ").append(baseObject != null ? baseObject.getClass() : " is null");
            OrderMate.LOG.error(SB.toString(), (Throwable)e);
            return null;
        }
    }

    public int getIndex() {
        return this.index;
    }
}

