/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import officemate.components.tableformat.renderers.IgnoreMouseDragListener;

public abstract class AbstractDialogCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    protected static Object NULL_OBJECT = new Object();
    private AbstractButton editButton;
    protected Object currentValue;
    private IgnoreMouseDragListener listener;

    public AbstractDialogCellEditor() {
        this(new JButton());
    }

    public AbstractDialogCellEditor(AbstractButton newEditButton) {
        this.editButton = newEditButton;
        this.listener = new IgnoreMouseDragListener(this);
        this.editButton.addMouseListener(this.listener);
        this.editButton.addMouseMotionListener(this.listener);
        this.editButton.addActionListener(this);
        this.editButton.setBorderPainted(false);
    }

    protected Object getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    public abstract Object doDialog();

    public void setupButton(Object value, AbstractButton theButton) {
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setupButton(value, this.editButton);
        this.currentValue = value;
        return this.editButton;
    }

    public AbstractButton getEditButton() {
        return this.editButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object newValue;
        if (this.listener.mayEdit() && (newValue = this.doDialog()) != null) {
            if (newValue == NULL_OBJECT) {
                newValue = null;
            }
            this.currentValue = newValue;
        }
        this.fireEditingStopped();
    }
}

