/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.IgnoreMouseDragListener;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class AutoCompleteComboCellEditor
extends ComboBoxCellEditor {
    private final JComboBox comboBox;
    private final boolean emptyVal;
    private final IgnoreMouseDragListener listener;

    private AutoCompleteComboCellEditor(JComboBox newComboBox, boolean useEmptyVal) {
        super(newComboBox);
        this.comboBox = newComboBox;
        this.emptyVal = useEmptyVal;
        this.listener = new IgnoreMouseDragListener((TableCellEditor)((Object)this));
        this.comboBox.addMouseListener(this.listener);
        this.comboBox.addMouseMotionListener(this.listener);
        this.comboBox.getEditor().getEditorComponent().addMouseListener(this.listener);
        this.comboBox.getEditor().getEditorComponent().addMouseMotionListener(this.listener);
    }

    public AutoCompleteComboCellEditor(EventList data, boolean useEmptyVal, EditablePropertyColumnFormat.Empty customEmpty) {
        this(new JComboBox(), useEmptyVal);
        EventList list = data;
        if (useEmptyVal) {
            BasicEventList emptyChoiceList = new BasicEventList(data.getPublisher(), data.getReadWriteLock());
            emptyChoiceList.getReadWriteLock().writeLock().lock();
            emptyChoiceList.add((Object)customEmpty);
            emptyChoiceList.getReadWriteLock().writeLock().unlock();
            CompositeList compositeList = new CompositeList(data.getPublisher(), data.getReadWriteLock());
            compositeList.addMemberList(data);
            compositeList.addMemberList((EventList)emptyChoiceList);
            list = compositeList;
        }
        this.comboBox.setModel(new EventComboBoxModel(list));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.comboBox, (EventList)list);
        support.setStrict(true);
    }

    public AutoCompleteComboCellEditor(EventList data, boolean useEmptyVal) {
        this(data, useEmptyVal, EditablePropertyColumnFormat.Empty.NULL);
    }

    public AutoCompleteComboCellEditor(EventList data) {
        this(data, false);
    }

    public AutoCompleteComboCellEditor setComboRenderer(ListCellRenderer renderer) {
        this.comboBox.setRenderer(renderer);
        return this;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox box = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (this.emptyVal) {
            boolean foundIt = false;
            boolean indexOfEmpty = false;
            if (box.getSelectedItem() == null) {
                box.setSelectedItem(EditablePropertyColumnFormat.Empty.NULL);
            }
        }
        return box;
    }

    public Object getCellEditorValue() {
        Object val = super.getCellEditorValue();
        if (this.emptyVal && val.equals(EditablePropertyColumnFormat.Empty.NULL) || val == null || val.toString().equals("")) {
            return null;
        }
        if (val instanceof String) {
            ComboBoxModel model = this.comboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object obj = model.getElementAt(i);
                if (obj == null || obj.toString() == null || !obj.toString().trim().equalsIgnoreCase(val.toString().trim())) continue;
                return obj;
            }
            return this.comboBox.getSelectedItem();
        }
        return val;
    }
}

