/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class ColorCellRenderer
extends DefaultTableCellRenderer {
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private Border whiteInidicatorBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, new Color(235, 235, 210));

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        Color currentColour = null;
        if (color != null && color != "") {
            if (color instanceof Color) {
                currentColour = (Color)color;
            } else {
                throw new IllegalArgumentException(color + " is not an instanceof Color, but rather a " + (color != null ? color.getClass() : " null"));
            }
        }
        super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, column);
        this.setText(color == null ? "(Default)" : null);
        this.setForeground(Color.GRAY);
        super.setBackground(currentColour);
        if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            if (this.unselectedBorder == null) {
                this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
            }
            if (Color.WHITE.equals(currentColour)) {
                this.setBorder(this.whiteInidicatorBorder);
            } else {
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }

    @Override
    public void setBackground(Color c) {
    }
}

