/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class NotNullCellEditorWrapper
implements TableCellEditor {
    private TableCellEditor delegate;
    private Object nullValue;

    public NotNullCellEditorWrapper(TableCellEditor theDelegate, Object theNullValue) {
        if (theNullValue == null) {
            throw new NullPointerException("Its a not null cell editor, what value are we replacing null with?");
        }
        if (theDelegate == null) {
            throw new NullPointerException("Must have a delegate editor");
        }
        this.nullValue = theNullValue;
        this.delegate = theDelegate;
    }

    public NotNullCellEditorWrapper(JTextField textField) {
        this(new DefaultCellEditor(textField), "");
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.delegate.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        Object value = this.delegate.getCellEditorValue();
        if (value == null) {
            value = this.nullValue;
        }
        return value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        boolean result = this.delegate.isCellEditable(anEvent);
        return result;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.delegate.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }
}

