/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.renderers;

import au.com.ordermate.units.SalesQuantity;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;

public class SalesQuantityEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JSpinner spinner;

    public SalesQuantityEditor(boolean decimals) {
        this.spinner = decimals ? new JSpinner(new SpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 1.0)) : new JSpinner(new SpinnerNumberModel(1, 0, Integer.MAX_VALUE, 1));
    }

    @Override
    public Object getCellEditorValue() {
        BigDecimal dec;
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            this.spinner.setValue(0);
        }
        Number value = (Number)this.spinner.getValue();
        if (value != null && (dec = new BigDecimal(value.toString())).doubleValue() > 0.0) {
            return new SalesQuantity(dec);
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            this.spinner.setValue(0.0);
        } else {
            this.spinner.setValue(((SalesQuantity)value).getValue());
        }
        return this.spinner;
    }
}

