/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat.textformat;

import au.com.ordermate.persistence.Displayable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import ordermate.gui.DisplayableString;

public class DisplayableListFormat
extends Format {
    private final boolean useToString;
    private Integer limitToShow;

    public DisplayableListFormat() {
        this(false);
    }

    public DisplayableListFormat(boolean useToString) {
        this.useToString = useToString;
    }

    public DisplayableListFormat(int numItemsToShow) {
        this();
        this.limitToShow = numItemsToShow;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        ArrayList displayableCollection = (ArrayList)obj;
        if (displayableCollection == null || displayableCollection.size() == 0) {
            return toAppendTo;
        }
        if (displayableCollection.size() == 1) {
            toAppendTo.append(displayableCollection.iterator().next());
            return toAppendTo;
        }
        displayableCollection = new ArrayList((Collection)obj);
        int count = 1;
        for (Displayable displayable : displayableCollection) {
            toAppendTo.append(this.getDisplayableLabel(displayable));
            if (this.limitToShow != null && ++count == this.limitToShow) {
                toAppendTo.append("...");
                break;
            }
            if (count > displayableCollection.size()) continue;
            toAppendTo.append(", ");
        }
        return toAppendTo;
    }

    protected String getDisplayableLabel(Displayable toDisplay) {
        if (this.useToString) {
            return toDisplay.toString();
        }
        return toDisplay.getLabel();
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int startIndex;
        ArrayList<DisplayableString> list = new ArrayList<DisplayableString>();
        if (source == null || source.trim().length() == 0) {
            return list;
        }
        StringBuffer currentStringBuffer = new StringBuffer();
        for (int i = startIndex = pos.getIndex(); i < source.length(); ++i) {
            if (source.charAt(i) == ',') {
                list.add(new DisplayableString(currentStringBuffer.toString()));
                currentStringBuffer = new StringBuffer();
                ++i;
            } else {
                currentStringBuffer.append(source.charAt(i));
            }
            pos.setIndex(i);
        }
        return list;
    }
}

