/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import officemate.components.tree.TransferableNode;

public class TreeNodeTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            return new TransferableNode(node);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(TransferableNode.FLAVOR) || !support.isDrop()) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        if (dropLocation.getPath() == null) {
            return false;
        }
        return dropLocation.getPath() != null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        DefaultMutableTreeNode parentNode;
        DefaultMutableTreeNode newNode;
        DefaultMutableTreeNode transferData;
        if (!this.canImport(support)) {
            return false;
        }
        JTree tree = (JTree)support.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dropLocation.getPath();
        Transferable transferable = support.getTransferable();
        try {
            transferData = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.FLAVOR);
        }
        catch (IOException e) {
            return false;
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        int childIndex = dropLocation.getChildIndex();
        if (childIndex == -1) {
            childIndex = model.getChildCount(path.getLastPathComponent());
        }
        if (this.isNodeAncestor(newNode = transferData, parentNode = (DefaultMutableTreeNode)path.getLastPathComponent())) {
            return false;
        }
        model.insertNodeInto(newNode, parentNode, childIndex);
        TreePath newPath = path.pathByAddingChild(newNode);
        tree.makeVisible(newPath);
        tree.scrollRectToVisible(tree.getPathBounds(newPath));
        return true;
    }

    private boolean isNodeAncestor(DefaultMutableTreeNode anotherNode, DefaultMutableTreeNode ancestor) {
        DefaultMutableTreeNode theAncestor = ancestor;
        do {
            if (!theAncestor.getUserObject().equals(anotherNode.getUserObject())) continue;
            return true;
        } while ((theAncestor = (DefaultMutableTreeNode)theAncestor.getParent()) != null);
        return false;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            JTree tree = (JTree)source;
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            try {
                DefaultMutableTreeNode transferData = (DefaultMutableTreeNode)data.getTransferData(TransferableNode.FLAVOR);
                model.removeNodeFromParent(transferData);
            }
            catch (IOException e) {
                return;
            }
            catch (UnsupportedFlavorException e) {
                return;
            }
        }
    }
}

