/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import java.util.Collection;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.RestrictedGUIState;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.statebuilder.DefaultApplicationNavigator;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintUtils;
import ordermate.database.config.custompermission.CustomPermissionHelper;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.gui.modify.AWTInterceptor;
import ordermate.gui.modify.ComponentListener;
import ordermate.gui.modify.security.UserSecurityManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class DefaultApplicationSecurity
implements ApplicationSecurity {
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";
    private static final String HIDDEN = "HIDDEN";
    private final LoginState loginState;
    private UserSecurityManager userSecurityManager;
    private DefaultApplicationNavigator navigator;
    private User user;
    public final Signal userChanged = Signals.createSignal();

    public DefaultApplicationSecurity(Signal exit, Signal logout) {
        this.userSecurityManager = this.createApplicationUserSecurityManager();
        AWTInterceptor.addListener((ComponentListener)this.userSecurityManager);
        LoginState.constructState(this.userSecurityManager);
        this.loginState = LoginState.getInstance();
        this.configureLoginState(this.loginState);
        this.loginState.exit.connect((Object)this, "exit");
        this.loginState.login.connect((Object)this, "logIn");
        exit.connect((Object)this, "exit");
        logout.connect((Object)this, "logOut");
    }

    protected void configureLoginState(LoginState loginState) {
    }

    protected abstract UserSecurityManager createApplicationUserSecurityManager();

    protected void setUser(User u) {
        boolean changed = this.user == null || !this.user.equals((Object)u);
        this.user = u;
        if (changed) {
            this.userChanged.emit();
        }
    }

    public void logIn(User loginUser) {
        if (this.navigator == null) {
            throw new IllegalStateException("ApplicationNavigator cannot be null! be sure to set it!");
        }
        this.setUser(loginUser);
        this.userSecurityManager.gotNewUser(this.user);
        this.navigator.navigateTo("Welcome");
        this.navigator.shouldResolve();
        StockControlEventLog.logLogin((User)loginUser, (String)GuiApp.getAppComplex().getApplicationFrame().getProductName());
    }

    public void logOut() {
        GuiApp.getAppComplex().getApplicationNavigator().navigateTo("Logout");
        User currentUser = this.getUser();
        this.userSecurityManager.gotNoUser();
        StockControlEventLog.logStockAdminLogout((User)currentUser);
        this.setUser(null);
    }

    public void exit() {
        this.exit(0);
    }

    public void exit(int errorCode) {
        this.doClose();
        System.exit(errorCode);
    }

    public void doClose() {
    }

    public boolean stateIsAccessable(GUIStateI desiredState, User currentUser) {
        return ENABLED.equals(this.getAccessLevel(desiredState, currentUser));
    }

    public boolean stateIsAccessable(String blueprintKey, User currentUser) {
        return ENABLED.equals(this.getAccessLevel(blueprintKey, currentUser));
    }

    public String getAccessLevel(GUIStateI desiredState, User currentUser) {
        if (desiredState == null) {
            return HIDDEN;
        }
        String accessLevel = CustomPermissionHelper.getAccessLevel((GUIStateI)desiredState, (User)currentUser);
        if (accessLevel != null) {
            return accessLevel;
        }
        Permission permission = ((RestrictedGUIState)desiredState).getAccessPermission();
        accessLevel = ENABLED;
        if (currentUser != null) {
            accessLevel = permission != null ? currentUser.getPermissionAccessLevel(permission) : (desiredState.hasSubStates() ? this.getMostLenientAccessLevel(desiredState.getSubStates()) : (this.hasChildBlueprint(desiredState) ? this.getAccessLevel(desiredState.getStateKey(), currentUser) : currentUser.getPermissionAccessLevel(this.getParentPermission(desiredState))));
        }
        return accessLevel;
    }

    public String getAccessLevel(String blueprintKey, User currentUser) {
        OfficeMateBlueprintArchitecture architecture = (OfficeMateBlueprintArchitecture)GuiApp.getAppComplex().getApplicationStructure().getArchitecture();
        ApplicationStateBlueprint blueprint = this.getBlueprint(blueprintKey);
        return OfficeMateBlueprintUtils.getAccessLevel(currentUser, blueprint, architecture);
    }

    public User getUser() {
        return this.user;
    }

    public String getAccessLevel(GUIStateI desiredState) {
        return this.getAccessLevel(desiredState, this.getUser());
    }

    protected String getMostLenientAccessLevel(Collection<? extends GUIStateI> childrenStates) {
        String mostLenientChildAccess = HIDDEN;
        for (GUIStateI gUIStateI : childrenStates) {
            if (!(gUIStateI instanceof RestrictedGUIState)) continue;
            RestrictedGUIState restrictedChild = (RestrictedGUIState)gUIStateI;
            String childAccess = restrictedChild.getAccessLevel();
            if (childAccess.equals(ENABLED)) {
                mostLenientChildAccess = ENABLED;
                break;
            }
            if (!childAccess.equals(DISABLED) || !mostLenientChildAccess.equals(HIDDEN)) continue;
            mostLenientChildAccess = DISABLED;
        }
        return mostLenientChildAccess;
    }

    protected Permission getParentPermission(GUIStateI desiredState) {
        if (desiredState.getParentState() != null && desiredState.getParentState() instanceof BasicOfficeMateState) {
            BasicOfficeMateState parent = (BasicOfficeMateState)desiredState.getParentState();
            if (parent.getAccessPermission() == null) {
                return this.getParentPermission(parent);
            }
            return parent.getAccessPermission();
        }
        return null;
    }

    public void setNavigator(ApplicationNavigator applicationNavigator) {
        this.navigator = (DefaultApplicationNavigator)applicationNavigator;
    }

    private boolean hasChildBlueprint(GUIStateI state) {
        ApplicationStateBlueprint blueprint = this.getBlueprint(state.getStateKey());
        return !blueprint.getChildStateKeys().isEmpty();
    }

    private ApplicationStateBlueprint getBlueprint(String stateKey) {
        ApplicationBlueprintArchitecture architecture = GuiApp.getAppComplex().getApplicationStructure().getArchitecture();
        return architecture.getBlueprint(stateKey);
    }
}

