/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.NumberFunction;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.customers.LoyaltyFunctionPanel;
import ordermate.database.EventContext;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomerLoyaltyFunctionsState
extends AbstractTableState<Customer> {
    private final EventList<CustomerCategory> customerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    protected CustomerSearcherGui customerSearchState;
    private final PagerModel listPager = new PagerModel(1000);
    private LoyaltyFunctionAction performLoyaltyFunction = new LoyaltyFunctionAction();
    private LoyaltyFunctionPanel dialogPanel;
    private EventContext eventContext;
    private static final int MAX_NUM_CUST_TO_SHOW = 5;

    public CustomerLoyaltyFunctionsState() {
        super("Customer Loyalty Functions", null, "Perform Functions");
        this.addSelectionDependentAction((Action)((Object)this.performLoyaltyFunction));
        this.dialogPanel = new LoyaltyFunctionPanel();
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addPageControl(this.listPager);
    }

    @Override
    protected TableStateCentralArea<Customer> createCentralArea() {
        PersistentObjectTable<Customer> table = new PersistentObjectTable<Customer>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat((PropertiedObject.Property)Customer.Properties.NAME_AND_TITLE), new PropertyColumnFormat(Customer.Properties.CATEGORY), new PropertyColumnFormat(Customer.Properties.LOYALTY_POINTS)}));
        return table;
    }

    @Override
    public OfficeMateObjectSearch<Customer> createSearchPanelFactory() {
        this.customerSearchState = new CustomerSearcherGui(this.customerCategories, new RefreshAction((Refreshable)this), false);
        this.customerSearchState.usePagedObjectQueryRefreshStrategy((Pager)this.listPager);
        this.addAction((Action)this.customerSearchState.getAdvancedSearch().getAction("Advanced Search", "/officemate/images/search.png", null));
        return this.customerSearchState;
    }

    @Override
    protected Class<Customer> getDisplayingType() {
        return Customer.class;
    }

    EventContext getEventContext() {
        if (this.eventContext == null) {
            this.eventContext = OfficeMate.getInstance().getEventContext();
        }
        return this.eventContext;
    }

    void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public void doLoyaltyFunction(List<Customer> selectedCustomers) {
        this.dialogPanel.setExampleCustomer(selectedCustomers.get(0));
        OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(this.dialogPanel);
        dialog.setTitle("Edit Customer Loyalty Points").setHtmlHeader(this.dialogPanel.getHTMLHeader()).doPack();
        if (dialog.doShow()) {
            CalculateLoyaltyTask loyaltyTask = new CalculateLoyaltyTask(selectedCustomers);
            Dialogs.showProgressDialog((AbstractTask)loyaltyTask);
            this.refresh();
            if (loyaltyTask.isSuccessful()) {
                Dialogs.showInfoDialog("Update Complete", selectedCustomers.size() + " Customers were successfully updated");
            } else {
                StringBuilder sb = new StringBuilder("An error occurred while updating Customers, the following Customers could not be updated:").append(System.getProperty("line.separator"));
                Iterator<Customer> custIterator = loyaltyTask.getFailedCustomers().iterator();
                int i = 0;
                while (custIterator.hasNext()) {
                    Customer cust = custIterator.next();
                    sb.append(System.getProperty("line.separator")).append(cust.getName());
                    if (++i < 5 || !custIterator.hasNext()) continue;
                    sb.append(System.getProperty("line.separator")).append("Plus ").append(loyaltyTask.getFailedCustomers().size() - i).append(" more ...");
                    break;
                }
                Dialogs.showErrorDialog("Update Failed", sb.toString());
            }
        }
    }

    boolean calculateLoyalty(List<Customer> selectedCustomers, NumberFunction function, Double value, Set<Customer> failedCustomers) {
        boolean result = true;
        for (Customer cust : selectedCustomers) {
            Integer newLoyaltyValue = new Integer((int)function.doFunction((Number)new Integer(cust.getLoyaltyPoints()), (Number)value));
            if (LoyaltyPointAdministrator.getInstance().setLoyaltyPoints(cust, newLoyaltyValue.intValue(), this.getEventContext())) continue;
            failedCustomers.add(cust);
            result = false;
        }
        return result;
    }

    class CalculateLoyaltyTask
    extends AbstractGuiTask {
        List<Customer> customers;
        private boolean successful;
        private Set<Customer> failedCustomers;

        public CalculateLoyaltyTask(List<Customer> selectedCustomers) {
            this.customers = selectedCustomers;
            this.failedCustomers = new HashSet<Customer>();
        }

        protected void doGuiTask() throws Exception {
            this.successful = CustomerLoyaltyFunctionsState.this.calculateLoyalty(this.customers, CustomerLoyaltyFunctionsState.this.dialogPanel.getFunction(), CustomerLoyaltyFunctionsState.this.dialogPanel.getValue(), this.failedCustomers);
        }

        public String getName() {
            return "Calculating Loyalty Values...";
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        protected boolean isSuccessful() {
            return this.successful;
        }

        protected Set<Customer> getFailedCustomers() {
            return this.failedCustomers;
        }
    }

    class LoyaltyFunctionAction
    extends BasicAction {
        public LoyaltyFunctionAction() {
            super("Adjust Loyalty", (Icon)IconLoader.get((String)"/officemate/images/bookmark_add.png"), "Adjust Multiple Customer's Loyalty Points");
        }

        public void actionPerformed(ActionEvent e) {
            List<Customer> editObj = CustomerLoyaltyFunctionsState.this.getCentralArea().getAllSelectedObjects();
            CustomerLoyaltyFunctionsState.this.doLoyaltyFunction(editObj);
        }
    }
}

