/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.util.Price;
import ca.odell.glazedlists.FilterList;
import java.util.HashMap;
import java.util.List;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.table.ColumnValueResolver;
import officemate.screens.customers.advanced.CustomerSalesSummarySearcher;
import ordermate.database.reports.CustomerSalesSummary;
import ordermate.database.sales.Customer;

class CustomerTotalSpendings
implements ColumnValueResolver<Customer, Price> {
    protected static final String IDENTIFIER = "Spent";
    protected HashMap<Customer, CustomerSalesSummary> salesMap = new HashMap();

    CustomerTotalSpendings() {
    }

    @Override
    public Price resolveValue(Customer value) {
        if (this.salesMap.containsKey(value)) {
            CustomerSalesSummary grabbedValue = this.salesMap.get(value);
            return grabbedValue.getTotalSales();
        }
        return Price.ZERO_DOLLAR;
    }

    public void createMap(CustomerSearcherGui customerSearcher, CustomerSalesSummarySearcher customerSalesSearcher) {
        if (customerSearcher.getObjectList().size() <= 0) {
            return;
        }
        FilterList customerFilteredList = customerSearcher.getObjectList();
        customerSalesSearcher.getCustomerFilter().setSearchValue(customerFilteredList);
        List customerSalesFilteredList = customerSalesSearcher.search();
        for (CustomerSalesSummary summary : customerSalesFilteredList) {
            this.salesMap.put(summary.getCustomer(), summary);
        }
    }
}

