/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.oquery.search.filter.implementation.CustomerTenureSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FrequentCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.NewCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.PolyEmptyPropertySearchFilter;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.AbstractObjectEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.translator.CustomerTenureSearchTranslator;
import officemate.components.search.translator.DefaultSearcherTranslator;
import officemate.components.search.translator.FrequentCustomerTranslator;
import officemate.components.search.translator.NewCustomerTranslator;
import officemate.components.search.translator.PolyEmptyPropertyTranslator;
import officemate.components.search.translator.SearcherTranslator;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.ResolvingColumnFormat;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.customers.CustomerColumnTableFormat;
import officemate.screens.customers.CustomerTableFactory;
import officemate.screens.customers.CustomerTotalSpendings;
import officemate.screens.customers.advanced.CustomerSalesSummarySearcher;
import officemate.screens.customers.external.ImportCustomerAction;
import officemate.screens.reports.CSVExportAction;
import ordermate.database.integration.coupon.CustomerCouponAssigner;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerSearcher;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.swingx.JXTable;

public class CustomersState
extends AbstractEditableTableState<Customer> {
    private final EventList<CustomerCategory> customerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private PersistentObjectTable<Customer> centralArea;
    private final PagerModel listPager = new PagerModel(1000);
    private final CustomerTableFactory customerTableFactory;
    protected CustomerSearcherGui customerSearcherGui;
    protected CustomerSalesSummarySearcher customerSalesSearcher;
    protected CustomerTotalSpendings spendingsColumn;
    private DefaultSearcherTranslator simpleSearchQuery;
    private CustomerColumnTableFormat customerSalesTableFormat;
    private ImportCustomerAction importAction;
    private Action resyncPointsAction;
    private boolean addExportAction;
    private final PropertiedObject.Property[] PROP_TO_EXCLUDE_MULTI_EDIT;

    public CustomersState(Permission permission) {
        this(permission, true);
    }

    public CustomersState(Permission permission, boolean addExportAction) {
        super("Customers", permission, "View, edit and delete customers");
        this.PROP_TO_EXCLUDE_MULTI_EDIT = new PropertiedObject.Property[]{Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME, Customer.Properties.ROOM_APT_NUMBER, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.STREET_TYPE, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.POSTCODE, Customer.Properties.LOYALTY_POINTS};
        this.addExportAction = addExportAction;
        this.customerTableFactory = this.getTablefactory();
        DeferredSaveStrategy strategy = new DeferredSaveStrategy((Refreshable)this).setRefreshOnSave(false);
        this.setSaveStrategy(strategy);
    }

    protected CustomerTableFactory getTablefactory() {
        return new CustomerTableFactory();
    }

    @Override
    public ObjectEditor<Customer> createObjectEditor() {
        AbstractObjectEditor<Customer> editor = new AbstractObjectEditor<Customer>(){

            @Override
            protected void init() {
                super.init();
                FieldPanelBuilder builder = new FieldPanelBuilder();
                this.addBoundRow(builder, "First Name", new JTextField(20), Customer.Properties.FIRST_NAME, "text");
                this.addBoundRow(builder, "Last Name", new JTextField(20), Customer.Properties.LAST_NAME, "text");
                this.addBoundRow(builder, "Primary Phone Number", new JTextField(20), Customer.Properties.PRIMARY_PHONE_NUMBER, "text");
                this.add(builder.getPanel());
            }
        };
        return editor;
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.importAction = new ImportCustomerAction();
        ImportCustomerAction.doAfterActionHandled.connect((Object)this, "refresh");
        this.addAction((Action)((Object)this.importAction));
        if (this.addExportAction) {
            this.addAction(this.getExportCustomerAction());
        }
        if (HOConfig.getInstance().isConfigured()) {
            this.resyncPointsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dialogs.createProgressDialog(new ResyncCustomersTask(CustomersState.this.getCentralArea().getAllSelectedObjects())).start();
                    CustomersState.this.refresh();
                }
            };
            this.addSelectionDependentAction(this.resyncPointsAction);
        }
        this.addSelectionDependentAction(this.centralArea.getEditMultipleAction());
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.CouponsIntegrationEnabled)) {
            this.addSelectionDependentAction(new AbstractAction("Assign Coupon", IconLoader.get((String)"/officemate/images/customer_coupon.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomersState.this.assignCoupons();
                }
            });
        }
        this.addPageControl(this.listPager);
    }

    @Override
    public String getTypeName() {
        return "Customer";
    }

    @Override
    public TableStateCentralArea<Customer> createCentralArea() {
        if (this.customerSalesSearcher == null) {
            this.customerSalesSearcher = this.createSalesSummarySearcher();
        }
        if (this.customerSearcherGui == null) {
            this.customerSearcherGui = this.createSearchPanelFactory();
        }
        this.spendingsColumn = new CustomerTotalSpendings();
        this.spendingsColumn.createMap(this.customerSearcherGui, this.customerSalesSearcher);
        this.customerSalesTableFormat = new CustomerColumnTableFormat(this.customerCategories, this);
        this.customerSalesTableFormat.addColumn((ColumnFormat)new ResolvingColumnFormat("Spent", String.class, this.spendingsColumn));
        this.centralArea = this.customerTableFactory.createCustomerTable(this.getObjectList(), this.customerSalesTableFormat);
        JPanel searchPanel = this.getSearchFactory().getSearchPanel();
        JXTable table = this.centralArea.getTable();
        this.customerSearcherGui.addToEast(this.buildCheckBoxes(table));
        this.centralArea.add((Component)searchPanel, "North");
        this.centralArea.add((Component)this.getSearcherTranslator().getGuiComponent(), "South");
        this.centralArea.setPropertiesToBulkExclude(this.PROP_TO_EXCLUDE_MULTI_EDIT);
        this.addAction((Action)this.customerSearcherGui.getAdvancedSearch().getAction("Advanced Search", "/officemate/images/search.png", null));
        return this.centralArea;
    }

    @Override
    public void refresh() {
        if (this.customerSearcherGui != null) {
            this.getSearcherTranslator().updateTranslation((AbstractSearcher<? extends PersistentObjectI>)((CustomerSearcher)this.customerSearcherGui.getSearcher()));
        }
        super.refresh();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.customerCategories, CustomerCategory.getAllCategories());
    }

    @Override
    public Class<Customer> getDisplayingType() {
        return Customer.class;
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.spendingsColumn.createMap(this.customerSearcherGui, this.customerSalesSearcher);
    }

    @Override
    public OfficeMateObjectSearch<Customer> getSearchFactory() {
        return this.customerSearcherGui;
    }

    public CustomerSearcherGui createSearchPanelFactory() {
        this.customerSearcherGui = new CustomerSearcherGui(this.customerCategories, new RefreshAction((Refreshable)this), false);
        this.customerSearcherGui.usePagedObjectQueryRefreshStrategy((Pager)this.getListPager());
        return this.customerSearcherGui;
    }

    protected CustomerSalesSummarySearcher createSalesSummarySearcher() {
        return new CustomerSalesSummarySearcher();
    }

    @Override
    protected String getObjectLabel(Customer toGet) {
        return toGet.toString();
    }

    protected PagerModel getListPager() {
        return this.listPager;
    }

    protected void assignCoupons() {
        CustomerCouponAssigner assigner = new CustomerCouponAssigner(this.centralArea.getAllSelectedObjects(), (GuiHandler)new OfficeMateGuiHandler(), (CouponAdministrator)CouponAdministratorRemote.getInstance(), !this.isHeadOffice());
        assigner.assignCoupons();
    }

    protected boolean isHeadOffice() {
        return false;
    }

    private JComponent buildCheckBoxes(JXTable table) {
        JPanel container = new JPanel(new GridLayout(4, 2));
        JCheckBox addressBox = new JCheckBox("Show Address");
        addressBox.setSelected(true);
        new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.ROOM_APT_NUMBER, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.STREET_TYPE, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.POSTCODE}, addressBox, table);
        container.add(addressBox);
        ColumnVisibilityHelper secondaryPhone = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.SECONDARY_PHONE_NUMBER}, new JCheckBox("Show Secondary Phone"), table);
        container.add(secondaryPhone.getCheckBox());
        ColumnVisibilityHelper occupationHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.OCCUPATION, Customer.Properties.COMPANY}, new JCheckBox("Show Occupation"), table);
        container.add(occupationHelper.getCheckBox());
        JCheckBox salesCheckBox = new JCheckBox("Sales Details");
        salesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomersState.this.refresh();
            }
        });
        ColumnVisibilityHelper salesHelper = new ColumnVisibilityHelper(new Object[]{Customer.Properties.LOYALTY_POINTS, "Spent"}, salesCheckBox, table);
        container.add(salesHelper.getCheckBox());
        ColumnVisibilityHelper marketingHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.E_MAIL, Customer.Properties.RECEIVE_MARKETING}, new JCheckBox("Show Email"), table);
        container.add(marketingHelper.getCheckBox());
        ColumnVisibilityHelper commentsHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.COMMENTS}, new JCheckBox("Show Comments"), table);
        container.add(commentsHelper.getCheckBox());
        ColumnVisibilityHelper anniversaryHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Customer.Properties.ANNIVERSARY}, new JCheckBox("Show Anniversary"), table);
        container.add(anniversaryHelper.getCheckBox());
        ColumnVisibilityHelper statsHelper = new ColumnVisibilityHelper((Object[])new String[]{"Total Orders", "Total Spending", "First Order", "Last Order", "Order Frequency", "Average Spend", "Most Ordered Item", "Most Ordered Section", "Highest Grossing Item", "Highest Grossing Section"}, new JCheckBox("Show Stats"), table);
        container.add(statsHelper.getCheckBox());
        return container;
    }

    private SearcherTranslator getSearcherTranslator() {
        if (this.simpleSearchQuery == null) {
            this.simpleSearchQuery = new DefaultSearcherTranslator();
            this.simpleSearchQuery.registerNewTranslator(NewCustomerSearchFilter.class, NewCustomerTranslator.class);
            this.simpleSearchQuery.registerNewTranslator(CustomerTenureSearchFilter.class, CustomerTenureSearchTranslator.class);
            this.simpleSearchQuery.registerNewTranslator(PolyEmptyPropertySearchFilter.class, PolyEmptyPropertyTranslator.class);
            this.simpleSearchQuery.registerNewTranslator(FrequentCustomerSearchFilter.class, FrequentCustomerTranslator.class);
        }
        return this.simpleSearchQuery;
    }

    private Action getExportCustomerAction() {
        return new CSVExportAction(this.getObjectList(), this.customerSalesTableFormat.getColumns().toArray(new ColumnFormat[this.customerSalesTableFormat.getColumnCount()]), "customers.csv");
    }

    class ResyncCustomersTask
    extends AbstractTask {
        private List<Customer> customers;

        ResyncCustomersTask(List<Customer> customers) {
            this.customers = customers;
        }

        public String getName() {
            return "Resynching customer points";
        }

        protected void performTask() throws Exception {
            for (Customer nextCustomer : CustomersState.this.getCentralArea().getAllSelectedObjects()) {
                LoyaltyPointAdministrator.getInstance().resynchPointsForCustomer(nextCustomer);
            }
        }

        protected int getTotalSubTasks() {
            return 1;
        }
    }
}

