/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.util.NumberFunction;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.sales.Customer;
import ordermate.gui.FieldPanelBuilder;

public class LoyaltyFunctionPanel
extends JPanel {
    private final EventList<NumberFunction> numberFunctionList = GlazedLists.eventList((Collection)new ArrayList<NumberFunction>(){
        {
            this.add(new NumberFunction.SetFunction());
            this.add(new NumberFunction.AddFunction());
            this.add(new NumberFunction.SubtractFunction());
            this.add(new NumberFunction.MultiplyFunction());
            this.add(new NumberFunction.DivideFunction());
        }
    });
    Customer exampleCustomer;
    JComboBox functionComboBox = new JComboBox(new EventComboBoxModel(this.numberFunctionList));
    SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1.0, 0.0, 9.9999999E7, 1.0);
    JSpinner valueSpinner = new JSpinner(this.spinnerModel);
    JLabel exampleLabel;
    JLabel warnLabel = new JLabel("<html><h3>Note:</h3> This may take a some time to complete.<p> Users who use loyalty with Head Office may also experience slowness based on connectivity to the Head Office service.</html>");

    public LoyaltyFunctionPanel() {
        this.exampleLabel = new JLabel("<html></html>");
        this.functionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoyaltyFunctionPanel.this.updateLabel();
            }
        });
        this.valueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoyaltyFunctionPanel.this.updateLabel();
            }
        });
        JFormattedTextField spinnerTextfield = ((JSpinner.DefaultEditor)this.valueSpinner.getEditor()).getTextField();
        spinnerTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoyaltyFunctionPanel.this.updateLabel();
            }
        });
        this.functionComboBox.setSelectedIndex(0);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Function ", (Component)this.functionComboBox);
        builder.addRow("Value ", (Component)this.valueSpinner);
        builder.addRow("Example: ", (Component)this.exampleLabel);
        builder.addSeparator(null);
        builder.addRow(new JLabel(IconLoader.get((String)"/ordermate/images/critical.gif")), (Component)this.warnLabel);
        this.add(builder.getPanel());
    }

    private void updateLabel() {
        this.exampleLabel.setText("<html></html>");
        if (this.exampleCustomer != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>").append(this.exampleCustomer.getName()).append("'s Loyalty Points change from ").append("<b>").append(this.exampleCustomer.getLoyaltyPoints()).append("</b>").append(" to ").append("<b>").append((int)this.getFunction().doFunction((Number)this.exampleCustomer.getLoyaltyPoints(), (Number)this.getValue())).append("</b>").append("</html>");
            this.exampleLabel.setText(sb.toString());
        }
    }

    public NumberFunction getFunction() {
        NumberFunction numFunc = (NumberFunction)this.functionComboBox.getSelectedItem();
        return numFunc;
    }

    public Double getValue() {
        Number spin = (Number)this.valueSpinner.getValue();
        return new Double(spin.doubleValue());
    }

    public void setExampleCustomer(Customer customer) {
        this.exampleCustomer = customer;
        this.updateLabel();
    }

    public String getHTMLHeader() {
        return "This dialog allows you to edit loyalty point values for a range of selected customers.\n You can select whether to set, add, subract, multiply or divide points of a selected range of customers and then update those customers both locally and in Head Office";
    }
}

