/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import java.util.HashMap;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.table.IconTableCellRenderer;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.customers.LoyaltyPointSearchPanel;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class LoyaltyPointsState
extends AbstractTableState<LoyaltyPointTransaction> {
    private static final int PAGE_RESULTS = 1000;
    private PagerModel pager = new PagerModel(1000);

    public LoyaltyPointsState() {
        super("Loyalty Points", AllPermissions.CUSTOMER_ADMIN, "View the history of Customer's loyalty points");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addPageControl(this.pager);
    }

    @Override
    protected TableStateCentralArea<LoyaltyPointTransaction> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(LoyaltyPointTransaction.Properties.USER));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(LoyaltyPointTransaction.Properties.CUSTOMER));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Creation Time", (PropertiedObject.Property)LoyaltyPointTransaction.Properties.DATETIME_STRING));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(LoyaltyPointTransaction.Properties.DOLLAR_VALUE));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(LoyaltyPointTransaction.Properties.AMOUNT));
        PropertyColumnFormat adjFormat = new PropertyColumnFormat((PropertiedObject.Property)LoyaltyPointTransaction.Properties.MANUAL_ADJUSTMENT);
        HashMap<Object, String> iconMap = new HashMap<Object, String>();
        iconMap.put(Boolean.TRUE, "/officemate/images/ok_16.png");
        adjFormat.setCustomRenderer((TableCellRenderer)new IconTableCellRenderer(iconMap));
        format.addColumn((ColumnFormat)adjFormat);
        PersistentObjectTable<LoyaltyPointTransaction> table = new PersistentObjectTable<LoyaltyPointTransaction>(this.getObjectList(), format);
        table.groupOn(LoyaltyPointTransaction.Properties.CUSTOMER.getUserVisibleLabel(), new String[0]);
        return table;
    }

    @Override
    protected Class<LoyaltyPointTransaction> getDisplayingType() {
        return LoyaltyPointTransaction.class;
    }

    @Override
    public OfficeMateObjectSearch<LoyaltyPointTransaction> createSearchPanelFactory() {
        LoyaltyPointSearchPanel searcher = new LoyaltyPointSearchPanel();
        searcher.usePagedObjectQueryRefreshStrategy((Pager)this.pager);
        return searcher;
    }
}

