/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers.external;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.Gender;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class CustomerFieldMapper {
    private Map<PropertiedObject.Property, Integer> mappings;
    private PropertiedObject.Property[] mappedProperties;
    private DateFormat formatter;
    private String[] fields;
    private final Map<String, CustomerCategory> categoryMap;

    public CustomerFieldMapper(Map<PropertiedObject.Property, Integer> mappings, PropertiedObject.Property[] mappedProperties, DateFormat formatter, Map<String, CustomerCategory> categoryMap) {
        this.mappings = mappings;
        this.mappedProperties = mappedProperties;
        this.formatter = formatter;
        this.categoryMap = categoryMap;
    }

    public void setCustomerFieldsToSet(String[] fields) {
        this.fields = fields;
    }

    public void setCustomerFields(Customer c) throws Exception {
        if (this.fields != null) {
            for (int i = 0; i < this.mappedProperties.length; ++i) {
                this.setCustomerField(c, i);
            }
        } else {
            throw new InvalidInputException("no String[] of fields to apply to a customer");
        }
    }

    private void setCustomerField(Customer customer, int fieldNum) throws Exception {
        PropertiedObject.Property property = this.mappedProperties[fieldNum];
        Integer mappedColumn = this.mappings.get(property);
        if (mappedColumn != null && mappedColumn < this.fields.length) {
            String value = this.fields[mappedColumn];
            if (Date.class.isAssignableFrom(property.getType())) {
                try {
                    Date valueToSet = this.formatter.parse(value);
                    if (valueToSet == null && Config.isDebuging()) {
                        OrderMate.LOG.warn("Null date returned from CustomerFieldMapper.setCustomerField()");
                    }
                    PropertiedObject.PropsHelper.setPropertyValue((Object)customer, (PropertiedObject.Property)property, (Object)valueToSet);
                }
                catch (ParseException e) {
                    OrderMate.LOG.warn("Invalid date format given to Customer Field Mapper " + e);
                }
            } else if (Customer.Properties.LOYALTY_POINTS.equals((Object)property)) {
                try {
                    double points = Double.parseDouble(value);
                    PropertiedObject.PropsHelper.setPropertyValue((Object)customer, (PropertiedObject.Property)property, (Object)((int)points));
                }
                catch (NumberFormatException ex) {
                    OrderMate.LOG.warn("Cannot bring in points, not a number:", (Throwable)ex);
                }
            } else if (Customer.Properties.GENDER.equals((Object)property)) {
                if (value != null && value.length() > 0) {
                    if (StringUtils.startsWithIgnoreCase((String)value, (String)"m")) {
                        customer.setGender(Gender.Male);
                    } else if (StringUtils.startsWithIgnoreCase((String)value, (String)"f")) {
                        customer.setGender(Gender.Female);
                    }
                }
            } else if (Customer.Properties.CATEGORY.equals((Object)property)) {
                if (value != null && value.length() > 0) {
                    CustomerCategory category = this.categoryMap.get(value = value.trim());
                    if (category == null) {
                        category = new CustomerCategory();
                        category.setSystemState(SystemState.ACTIVE_STATE);
                        category.setLabel(value);
                        category.save();
                        this.categoryMap.put(value, category);
                    }
                    customer.setCategory(category);
                }
            } else {
                PropertiedObject.PropsHelper.setPropertyValue((Object)customer, (PropertiedObject.Property)property, (Object)value);
            }
        } else if (mappedColumn != null && mappedColumn >= this.fields.length) {
            throw new ArrayIndexOutOfBoundsException("mapped integer tried to retrieve a value out of arrayIndex bounds Indexmapped :" + mappedColumn + " field array length:" + this.fields.length);
        }
    }
}

